/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.DaoException;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;
import java.util.Arrays;

public class PersistentIntegerArray
extends PersistentField {
    public PersistentIntegerArray(Field field, int columnIndex) {
        super(field, columnIndex);
        this.mDatabaseDescription = "TEXT";
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException, DaoException {
        int[] integer = this.parseArray(cursor.getString(this.mColumnIndex));
        this.mField.set(domain, integer);
    }

    private int[] parseArray(String string) {
        if ("null".equals(string)) {
            return null;
        }
        String[] split = string.replace("[", "").replace("]", "").split(",");
        int[] integer = new int[split.length];
        for (int i = 0; i < split.length; ++i) {
            integer[i] = Integer.parseInt(split[i]);
        }
        return integer;
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        int[] integer = (int[])this.mField.get(domain);
        values.put(this.mColumnName, Arrays.toString(integer));
    }
}

