/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.DaoException;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;
import java.util.Arrays;

public class PersistentDoubleArray
extends PersistentField {
    public PersistentDoubleArray(Field field, int columnIndex) {
        super(field, columnIndex);
        this.mDatabaseDescription = "TEXT";
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException, DaoException {
        double[] doubles = this.parseArray(cursor.getString(this.mColumnIndex));
        this.mField.set(domain, doubles);
    }

    private double[] parseArray(String string) {
        String[] split = string.replace("[", "").replace("]", "").split(",");
        double[] doubles = new double[split.length];
        for (int i = 0; i < split.length; ++i) {
            doubles[i] = Double.parseDouble(split[i]);
        }
        return doubles;
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        double[] doubles = (double[])this.mField.get(domain);
        values.put(this.mColumnName, Arrays.toString(doubles));
    }
}

