/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence.fields;

import android.content.ContentValues;
import android.database.Cursor;
import de.neo.android.persistence.Dao;
import de.neo.android.persistence.DaoException;
import de.neo.android.persistence.DaoFactory;
import de.neo.android.persistence.DomainBase;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;

public class PersistentDomainBase
extends PersistentField {
    private Dao<?> dao;

    public PersistentDomainBase(Field field, int columnIndex) {
        super(field, columnIndex);
        this.mDatabaseDescription = "INTEGER";
    }

    public void init() {
        this.dao = DaoFactory.getInstance().getDao(this.mField.getType());
        if (this.dao == null) {
            throw new IllegalArgumentException("Field type must has a dao in the daofactory.");
        }
    }

    @Override
    public void setValueToDomain(Object domain, Cursor cursor) throws IllegalAccessException, IllegalArgumentException, DaoException {
        int id = cursor.getInt(this.mColumnIndex);
        Object domainObject = this.dao.loadById(id);
        this.mField.set(domain, domainObject);
    }

    @Override
    public void setValueToDatabase(Object domain, ContentValues values) throws IllegalAccessException, IllegalArgumentException {
        DomainBase domainObject = (DomainBase)this.mField.get(domain);
        if (domainObject != null) {
            values.put(this.mColumnName, Long.valueOf(domainObject.getId()));
        } else {
            values.put(this.mColumnName, Integer.valueOf(-1));
        }
    }
}

