/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import de.neo.android.persistence.Dao;
import de.neo.android.persistence.DaoBuilder;
import de.neo.android.persistence.DaoException;
import de.neo.android.persistence.DomainBase;
import de.neo.android.persistence.NeoDataBase;
import de.neo.android.persistence.Persistent;
import de.neo.android.persistence.fields.PersistentDomainBase;
import de.neo.android.persistence.fields.PersistentField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DatabaseDao<T extends DomainBase>
implements Dao<T> {
    public static final String FIELD_ID = "ID";
    public static final String WHERE_ID = "ID=?";
    public static final String TYPE_TEXT_SQL = "TEXT";
    public static final String TYPE_REAL_SQL = "REAL";
    public static final String TYPE_INTEGER_SQL = "INTEGER";
    public static final String TYPE_BLOB_SQL = "BLOB";
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_REAL = 1;
    public static final int TYPE_INTEGER = 2;
    public static final int TYPE_BLOB = 3;
    protected NeoDataBase mSqlLite;
    protected String mTableName;
    protected String[] mFieldsPlusId;
    protected Class<T> mDomainClass;
    protected String mCreateTable;
    protected List<PersistentField> mPersistentFields = new ArrayList<PersistentField>();
    protected Map<Long, T> mCache = new HashMap<Long, T>();

    @SuppressLint(value={"UseSparseArrays"})
    public DatabaseDao(Class<T> domainClass, DaoBuilder builder) {
        SQLiteDatabase db;
        this.mSqlLite = builder.getDatabase();
        this.mDomainClass = domainClass;
        this.mTableName = domainClass.getSimpleName().toUpperCase(Locale.US);
        this.checkDomainClass();
        this.initFields(builder.getPersistentFieldBuilder());
        if (this.mSqlLite.doDelete()) {
            db = this.mSqlLite.getWritableDatabase();
            this.deleteTable(db);
            db.close();
        }
        if (this.mSqlLite.doCreate()) {
            db = this.mSqlLite.getWritableDatabase();
            this.createTable(db);
            db.close();
        }
        this.mSqlLite.getDaoList().add(this);
    }

    private void checkDomainClass() {
        try {
            try {
                DomainBase dummyDomain = (DomainBase)this.mDomainClass.newInstance();
                dummyDomain.getClass();
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Domain class must be instance of generic class");
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Domain class must have public constructor without parameter");
        }
    }

    private void initFields(DaoBuilder.PersistentFieldBuilder fieldCreator) {
        this.mPersistentFields.clear();
        for (Field field : this.mDomainClass.getDeclaredFields()) {
            PersistentField pField = fieldCreator.createPersistentField(field, this.mPersistentFields.size() + 1);
            if (field.getAnnotation(Persistent.class) == null) continue;
            if (pField == null) {
                throw new IllegalArgumentException("Unknown persistent field: " + field.getType().getSimpleName());
            }
            this.mPersistentFields.add(pField);
        }
        String createFields = "";
        this.mFieldsPlusId = new String[this.mPersistentFields.size() + 1];
        this.mFieldsPlusId[0] = FIELD_ID;
        for (int i = 0; i < this.mPersistentFields.size(); ++i) {
            PersistentField field = this.mPersistentFields.get(i);
            this.mFieldsPlusId[i + 1] = field.mColumnName;
            if (i > 0) {
                createFields = createFields + ", ";
            }
            createFields = createFields + field.mColumnName + " " + field.mDatabaseDescription;
        }
        this.mCreateTable = "CREATE TABLE " + this.mTableName + " ( " + FIELD_ID + " INTEGER PRIMARY KEY AUTOINCREMENT, " + createFields + " )";
    }

    protected void initDependencyFields() {
        for (PersistentField field : this.mPersistentFields) {
            if (!PersistentDomainBase.class.isAssignableFrom(field.getClass())) continue;
            ((PersistentDomainBase)field).init();
        }
    }

    public void deleteTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS " + this.mTableName);
    }

    public void createTable(SQLiteDatabase db) {
        db.execSQL(this.mCreateTable);
    }

    protected T loadItemByCurser(Cursor cursor) throws DaoException {
        try {
            DomainBase domain = (DomainBase)this.mDomainClass.newInstance();
            for (PersistentField field : this.mPersistentFields) {
                field.setValueToDomain(domain, cursor);
            }
            return (T)domain;
        }
        catch (Exception e) {
            throw new DaoException(e.getClass().getSimpleName() + ":" + e.getMessage());
        }
    }

    @Override
    public List<T> loadAll() throws DaoException {
        return this.loadByWhereClausel(null, null, null, null);
    }

    protected List<T> loadByWhereClausel(String where, String[] values, String orderBy, String limit) throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getReadableDatabase();
            ArrayList<T> items = new ArrayList<T>();
            Cursor cursor = db.query(this.mTableName, this.mFieldsPlusId, where, values, null, null, orderBy, limit);
            while (cursor.moveToNext()) {
                int id = cursor.getInt(0);
                if (this.mCache.containsKey(id)) {
                    items.add(this.mCache.get(id));
                    continue;
                }
                T item = this.loadItemByCurser(cursor);
                ((DomainBase)item).setId(id);
                items.add(item);
                this.mCache.put(Long.valueOf(id), item);
            }
            ArrayList<T> arrayList = items;
            return arrayList;
        }
    }

    @Override
    public T loadById(long id) throws DaoException {
        if (this.mCache.containsKey(id)) {
            return (T)((DomainBase)this.mCache.get(id));
        }
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getReadableDatabase();
            Cursor cursor = db.query(this.mTableName, this.mFieldsPlusId, WHERE_ID, new String[]{id + ""}, null, null, null);
            DomainBase item = null;
            if (cursor.moveToNext()) {
                item = (DomainBase)this.loadItemByCurser(cursor);
                item.setId(id);
            }
            DomainBase domainBase = item;
            return (T)domainBase;
        }
    }

    protected ContentValues getContentValues(T item) throws DaoException {
        try {
            ContentValues values = new ContentValues();
            for (PersistentField field : this.mPersistentFields) {
                field.setValueToDatabase(item, values);
            }
            return values;
        }
        catch (Exception e) {
            throw new DaoException(e.getClass().getSimpleName() + ":" + e.getMessage());
        }
    }

    @Override
    public long save(T item) throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getWritableDatabase();
            long id = db.insert(this.mTableName, null, this.getContentValues(item));
            ((DomainBase)item).setId(id);
            this.mCache.put(id, item);
            long l = id;
            return l;
        }
    }

    @Override
    public void update(T item) throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getWritableDatabase();
            db.update(this.mTableName, this.getContentValues(item), WHERE_ID, new String[]{((DomainBase)item).getId() + ""});
            this.mCache.put(((DomainBase)item).getId(), item);
        }
    }

    @Override
    public void delete(long id) throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getWritableDatabase();
            db.delete(this.mTableName, WHERE_ID, new String[]{id + ""});
            this.mCache.remove(id);
        }
    }

    @Override
    public void deleteAll() throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getWritableDatabase();
            db.delete(this.mTableName, null, null);
            this.mCache.clear();
        }
    }

    protected long count(String where, String[] parameter) throws DaoException {
        try (SQLiteDatabase db = null;){
            db = this.mSqlLite.getReadableDatabase();
            Cursor c = db.query(this.mTableName, null, where, parameter, null, null, null);
            long result = c.getCount();
            c.close();
            long l = result;
            return l;
        }
    }

    @Override
    public long count() throws DaoException {
        return this.count(null, null);
    }
}

