/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.persistence;

import de.neo.android.persistence.Dao;
import de.neo.android.persistence.DomainBase;
import de.neo.android.persistence.NeoDataBase;
import de.neo.android.persistence.fields.PersistentBoolean;
import de.neo.android.persistence.fields.PersistentDate;
import de.neo.android.persistence.fields.PersistentDomainBase;
import de.neo.android.persistence.fields.PersistentDoubleArray;
import de.neo.android.persistence.fields.PersistentEnum;
import de.neo.android.persistence.fields.PersistentField;
import de.neo.android.persistence.fields.PersistentInteger;
import de.neo.android.persistence.fields.PersistentIntegerArray;
import de.neo.android.persistence.fields.PersistentLong;
import de.neo.android.persistence.fields.PersistentLongArray;
import de.neo.android.persistence.fields.PersistentText;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;

public class DaoBuilder {
    protected PersistentFieldBuilder mFieldBuilder = new PersistentDatabaseFieldBuilder();
    protected DaoMapFilling mDaoMapFilling;
    protected NeoDataBase mDatabase;

    public DaoBuilder setFieldBuilder(PersistentFieldBuilder builder) {
        this.mFieldBuilder = builder;
        return this;
    }

    public DaoBuilder setDaoMapFilling(DaoMapFilling filling) {
        this.mDaoMapFilling = filling;
        return this;
    }

    public DaoBuilder setDatabase(NeoDataBase database) {
        this.mDatabase = database;
        return this;
    }

    public NeoDataBase getDatabase() {
        return this.mDatabase;
    }

    public PersistentFieldBuilder getPersistentFieldBuilder() {
        return this.mFieldBuilder;
    }

    public class PersistentDatabaseFieldBuilder
    implements PersistentFieldBuilder {
        @Override
        public PersistentField createPersistentField(Field field, int number) {
            if (field.getType().equals(Integer.TYPE)) {
                return new PersistentInteger(field, number);
            }
            if (field.getType().equals(int[].class)) {
                return new PersistentIntegerArray(field, number);
            }
            if (field.getType().equals(Long.TYPE)) {
                return new PersistentLong(field, number);
            }
            if (field.getType().equals(long[].class)) {
                return new PersistentLongArray(field, number);
            }
            if (field.getType().equals(Boolean.TYPE)) {
                return new PersistentBoolean(field, number);
            }
            if (field.getType().isEnum()) {
                return new PersistentEnum(field, number, field.getType());
            }
            if (field.getType().equals(Date.class)) {
                return new PersistentDate(field, number);
            }
            if (field.getType().equals(String.class)) {
                return new PersistentText(field, number);
            }
            if (field.getType().equals(double[].class)) {
                return new PersistentDoubleArray(field, number);
            }
            if (DomainBase.class.isAssignableFrom(field.getType())) {
                return new PersistentDomainBase(field, number);
            }
            return null;
        }
    }

    public static interface DaoMapFilling {
        public void createDaos(Map<Class<?>, Dao<?>> var1, DaoBuilder var2);
    }

    public static interface PersistentFieldBuilder {
        public PersistentField createPersistentField(Field var1, int var2);
    }
}

