/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.systems.GLCube;
import de.neo.android.opengl.systems.GLCylinderClosed;
import javax.microedition.khronos.opengles.GL10;

public class GLTableround
extends GLFigure {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int PILLAR = 4;
    private GLCylinderClosed cylinder;
    private GLCube bottom;
    private GLCube pillar;

    public GLTableround(int style, float height, float width) {
        super(style);
        this.cylinder = new GLCylinderClosed(30, style);
        this.cylinder.mSize[2] = 0.1f;
        this.cylinder.mSize[0] = this.cylinder.mSize[1] = width;
        this.cylinder.mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
        this.cylinder.mPosition[1] = height;
        this.cylinder.setColor(0.5f, 0.5f, 0.5f);
        this.pillar = new GLCube(style);
        this.pillar.mSize[2] = 0.1f;
        this.pillar.mSize[0] = 0.1f;
        this.pillar.mSize[1] = this.cylinder.mPosition[1];
        this.pillar.mPosition[1] = this.pillar.mSize[1] / 2.0f;
        this.pillar.mColor[2] = 0.0f;
        this.pillar.mColor[1] = 0.0f;
        this.pillar.mColor[0] = 0.0f;
        this.bottom = new GLCube(style);
        this.bottom.mSize[0] = width * 0.7f;
        this.bottom.mSize[1] = 0.2f;
        this.bottom.mSize[2] = 0.2f;
        this.bottom.mColor[2] = 0.0f;
        this.bottom.mColor[1] = 0.0f;
        this.bottom.mColor[0] = 0.0f;
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.cylinder.draw(gl);
        this.pillar.draw(gl);
        this.bottom.mRotation.einselement();
        this.bottom.draw(gl);
        this.bottom.mRotation.rotateByAngleAxis(1.5707963267948966, 0.0f, 1.0f, 0.0f);
        this.bottom.draw(gl);
    }

    @Override
    public void setTexture(Bitmap b) {
        this.setTexture(7, b);
    }

    public void setTexture(int surface, Bitmap bitmap) {
        if ((surface & 1) != 0) {
            this.cylinder.setTexture(bitmap);
            this.cylinder.setColor(1.0f, 1.0f, 1.0f);
        }
        if ((surface & 4) != 0) {
            this.pillar.setTexture(bitmap);
            this.pillar.setColor(1.0f, 1.0f, 1.0f);
        }
        if ((surface & 2) != 0) {
            this.bottom.setTexture(bitmap);
            this.bottom.setColor(1.0f, 1.0f, 1.0f);
        }
    }
}

