/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import de.neo.android.opengl.figures.GLCircle;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLFunctionFigure;
import de.neo.android.opengl.systems.GLSwitch;
import javax.microedition.khronos.opengles.GL10;

public class GLLavalamp
extends GLSwitch {
    private GLFunctionFigure mFunction;
    private GLCircle mTop;
    private GLCircle mBottom;

    public GLLavalamp(int parts, int style) {
        super(style);
        GLFunctionFigure.Function f = new GLFunctionFigure.Function(){

            @Override
            public float getValue(float x) {
                return (float)(0.5 + 0.2 * Math.sin((double)(x * 2.0f) * Math.PI));
            }
        };
        this.mFunction = new GLFunctionFigure(parts, style, f);
        this.mTop = new GLCircle(parts, style);
        this.mBottom = new GLCircle(parts, style);
        this.mTop.mSize[0] = this.mTop.mSize[1] = f.getValue(1.0f);
        this.mTop.mPosition[1] = 1.0f;
        this.mBottom.mSize[0] = this.mBottom.mSize[1] = f.getValue(0.0f);
        this.mBottom.mPosition[1] = 0.0f;
        this.mTop.mRotation.rotateByAngleAxis(-1.5707963267948966, 1.0f, 0.0f, 0.0f);
        this.mBottom.mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
        this.setSwitch(true);
        this.mBottom.mColor[2] = 0.2f;
        this.mBottom.mColor[1] = 0.2f;
        this.mBottom.mColor[0] = 0.2f;
        this.mSize[1] = 1.0f;
        this.mSize[2] = 0.4f;
        this.mSize[0] = 0.4f;
    }

    @Override
    public void setSwitch(boolean b) {
        super.setSwitch(b);
        if (b) {
            this.mTop.mColor[0] = 1.0f;
            this.mFunction.mColor[0] = 1.0f;
            this.mTop.mColor[2] = 0.4f;
            this.mTop.mColor[1] = 0.4f;
            this.mFunction.mColor[2] = 0.4f;
            this.mFunction.mColor[1] = 0.4f;
        } else {
            this.mTop.mColor[0] = 0.4f;
            this.mFunction.mColor[0] = 0.4f;
            this.mTop.mColor[2] = 0.0f;
            this.mTop.mColor[1] = 0.0f;
            this.mFunction.mColor[2] = 0.0f;
            this.mFunction.mColor[1] = 0.0f;
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        this.mFunction.setOnClickListener(listener);
        this.mTop.setOnClickListener(listener);
        this.mBottom.setOnClickListener(listener);
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        this.mFunction.setOnLongClickListener(listener);
        this.mTop.setOnLongClickListener(listener);
        this.mBottom.setOnLongClickListener(listener);
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.mFunction.draw(gl);
        this.mTop.draw(gl);
        this.mBottom.draw(gl);
    }
}

