/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLCylinder;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.systems.GLCube;
import de.neo.android.opengl.systems.GLSwitch;
import javax.microedition.khronos.opengles.GL10;

public class GLFloorlamp
extends GLSwitch {
    public static final int BOTTOM = 1;
    public static final int PILLAR = 2;
    public static final int LIGHT = 4;
    public GLCube bottom;
    public GLCube light;
    public GLCylinder pillar;

    public GLFloorlamp(int style) {
        super(style);
        this.bottom = new GLCube(style);
        this.light = new GLCube(style);
        this.pillar = new GLCylinder(7, 0.2f, 0.2f, style, false);
        this.bottom.mSize[1] = 0.1f;
        this.light.mSize[2] = 0.5f;
        this.light.mSize[0] = 0.5f;
        this.bottom.mSize[2] = 0.5f;
        this.bottom.mSize[0] = 0.5f;
        this.bottom.mPosition[1] = 0.1f;
        this.light.mSize[1] = 1.5f;
        this.light.mPosition[1] = 0.6f + this.light.mSize[1] / 2.0f;
        this.pillar.mColor[2] = 0.3f;
        this.pillar.mColor[1] = 0.3f;
        this.pillar.mColor[0] = 0.3f;
        this.bottom.mColor[2] = 0.3f;
        this.bottom.mColor[1] = 0.3f;
        this.bottom.mColor[0] = 0.3f;
        this.setSwitch(true);
        this.pillar.mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
        this.pillar.mPosition[1] = 0.5f;
        this.pillar.mSize[1] = 0.4f;
        this.pillar.mSize[0] = 0.4f;
    }

    public void setTexture(int surface, Bitmap b) {
        if ((surface & 1) != 0) {
            this.bottom.setTexture(b);
            this.bottom.setColor(1.0f, 1.0f, 1.0f);
        }
        if ((surface & 2) != 0) {
            this.pillar.setTexture(b);
            this.pillar.mColor[2] = 1.0f;
            this.pillar.mColor[1] = 1.0f;
            this.pillar.mColor[0] = 1.0f;
        }
        if ((surface & 4) != 0) {
            this.light.setTexture(b);
            this.light.setColor(1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.bottom.draw(gl);
        this.light.draw(gl);
        this.pillar.draw(gl);
    }

    @Override
    public void setSwitch(boolean _light) {
        super.setSwitch(_light);
        if (_light) {
            this.light.setColor(1.0f, 1.0f, 0.3f);
        } else {
            this.light.setColor(0.2f, 0.2f, 0.2f);
        }
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        this.bottom.setOnClickListener(listener);
        this.light.setOnClickListener(listener);
        this.pillar.setOnClickListener(listener);
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        this.bottom.setOnLongClickListener(listener);
        this.light.setOnLongClickListener(listener);
        this.pillar.setOnLongClickListener(listener);
    }
}

