/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.systems;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLSquare;
import de.neo.android.opengl.systems.GLCube;
import de.neo.android.opengl.systems.GLSwitch;
import java.util.HashMap;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

public class GLFlatScreen
extends GLSwitch {
    public static final int BOTTOM = 4;
    public static final int SCREEN = 8;
    public static final int PILLAR = 16;
    private GLSquare screen;
    private GLSquare bottom;
    private GLCube pillar;
    private float screenWidth;
    private float screenHeigh;
    private float height;
    private Map<Integer, SwitchStateTexture> switchStateTextures = new HashMap<Integer, SwitchStateTexture>();

    public GLFlatScreen(int style, float screenWidth, float screenHeigh, float height) {
        super(style);
        this.screenWidth = screenWidth;
        this.screenHeigh = screenHeigh;
        this.height = height;
        this.screen = new GLSquare(style);
        this.initScreen();
        this.bottom = new GLSquare(style);
        this.initBottom();
        this.pillar = new GLCube(style);
        this.initPillar();
    }

    private void initPillar() {
        this.pillar.mSize[2] = 0.1f;
        this.pillar.mSize[0] = 0.1f;
        this.pillar.mPosition[2] = -this.pillar.mSize[0] / 2.0f - 0.01f;
        this.pillar.mSize[1] = this.screen.mPosition[1];
        this.pillar.mPosition[1] = this.pillar.mSize[1] / 2.0f;
        this.pillar.setColor(this.bottom.mColor[0], this.bottom.mColor[1], this.bottom.mColor[2]);
    }

    private void initBottom() {
        this.bottom.mSize[0] = this.screenWidth * 0.5f;
        this.bottom.mSize[1] = this.screenHeigh * 0.5f;
        this.bottom.mRotation.rotateByAngleAxis(1.5707963267948966, 1.0f, 0.0f, 0.0f);
        this.bottom.mColor[2] = 0.3f;
        this.bottom.mColor[1] = 0.3f;
        this.bottom.mColor[0] = 0.3f;
    }

    private void initScreen() {
        this.screen.mSize[0] = this.screenWidth;
        this.screen.mSize[1] = this.screenHeigh;
        this.screen.mPosition[1] = this.height - this.screenHeigh / 2.0f;
        this.screen.mColor[2] = 0.0f;
        this.screen.mColor[1] = 0.0f;
        this.screen.mColor[0] = 0.0f;
        this.screen.mRotation.rotateByAngleAxis(-Math.PI, 1.0f, 0.0f, 0.0f);
    }

    @Override
    protected void onDraw(GL10 gl) {
        this.screen.draw(gl);
        this.pillar.draw(gl);
        this.bottom.draw(gl);
    }

    @Override
    public void setOnClickListener(GLFigure.GLClickListener listener) {
        super.setOnClickListener(listener);
        this.screen.setOnClickListener(listener);
        this.bottom.setOnClickListener(listener);
        this.pillar.setOnClickListener(listener);
    }

    @Override
    public void setOnLongClickListener(GLFigure.GLClickListener listener) {
        super.setOnLongClickListener(listener);
        this.screen.setOnLongClickListener(listener);
        this.bottom.setOnLongClickListener(listener);
        this.pillar.setOnLongClickListener(listener);
    }

    public void setSwitchTexture(int surface, Bitmap b, boolean switchState) {
        SwitchStateTexture sst = this.switchStateTextures.get(surface);
        if (sst == null) {
            sst = new SwitchStateTexture();
            this.switchStateTextures.put(surface, sst);
        }
        if (switchState) {
            sst.textureOn = b;
        } else {
            sst.textureOff = b;
        }
    }

    @Override
    public void setSwitch(boolean on) {
        super.setSwitch(on);
        for (Integer surface : this.switchStateTextures.keySet()) {
            SwitchStateTexture sst = this.switchStateTextures.get(surface);
            if (on) {
                this.setTexture(surface, sst.textureOn);
                continue;
            }
            this.setTexture(surface, sst.textureOff);
        }
    }

    public void setTexture(int surface, Bitmap b) {
        if ((surface & 8) != 0) {
            if (b != null) {
                this.screen.mColor[2] = 1.0f;
                this.screen.mColor[1] = 1.0f;
                this.screen.mColor[0] = 1.0f;
            } else {
                this.initScreen();
            }
            this.screen.setTexture(b);
        }
        if ((surface & 4) != 0) {
            this.bottom.setTexture(b);
            if (b != null) {
                this.bottom.mColor[2] = 1.0f;
                this.bottom.mColor[1] = 1.0f;
                this.bottom.mColor[0] = 1.0f;
            } else {
                this.initBottom();
            }
        }
        if ((surface & 0x10) != 0) {
            this.pillar.setTexture(b);
            if (b != null) {
                this.pillar.setColor(1.0f, 1.0f, 1.0f);
            } else {
                this.initPillar();
            }
        }
    }

    private class SwitchStateTexture {
        public Bitmap textureOn;
        public Bitmap textureOff;

        private SwitchStateTexture() {
        }
    }
}

