/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLTorus
extends GLFigure {
    private int mMajorSlices = 40;
    private int mMinorSlices = 20;
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mNormalBuffer;
    private FloatBuffer mTextureBuffer;
    private float[] mTextureCoordinates;
    private ShortBuffer mIndexBuffer;
    private short[] mIndices;
    public int mPaintStyle;

    public GLTorus(float rmajor, float rminor, int style) {
        super(style);
        float[] vertex = new float[(this.mMajorSlices + 1) * (this.mMinorSlices + 1) * 3];
        float[] normal = new float[(this.mMajorSlices + 1) * (this.mMinorSlices + 1) * 3];
        float stepMajor = (float)(Math.PI * 2 / (double)this.mMajorSlices);
        float stepMinor = (float)(Math.PI * 2 / (double)this.mMinorSlices);
        for (int i = 0; i <= this.mMajorSlices; ++i) {
            float sinMajor = (float)Math.sin((float)i * stepMajor);
            float cosMajor = (float)Math.cos((float)i * stepMajor);
            for (int j = 0; j <= this.mMinorSlices; ++j) {
                float sinMinor = (float)Math.sin((double)((float)j * stepMinor) + Math.PI);
                float cosMinor = (float)Math.cos((double)((float)j * stepMinor) + Math.PI);
                vertex[(i * (this.mMinorSlices + 1) + j) * 3] = sinMajor * rmajor + cosMinor * rminor * sinMajor;
                vertex[(i * (this.mMinorSlices + 1) + j) * 3 + 1] = cosMajor * rmajor + cosMinor * rminor * cosMajor;
                vertex[(i * (this.mMinorSlices + 1) + j) * 3 + 2] = sinMinor * rminor;
                normal[(i * (this.mMinorSlices + 1) + j) * 3] = sinMajor + cosMinor * sinMajor;
                normal[(i * (this.mMinorSlices + 1) + j) * 3 + 1] = cosMajor + cosMinor * cosMajor;
                normal[(i * (this.mMinorSlices + 1) + j) * 3 + 2] = sinMinor;
            }
        }
        this.mVertexBuffer = this.allocate(vertex);
        this.mNormalBuffer = this.allocate(normal);
        if (style == 1) {
            this.makeGridIndices();
            this.mPaintStyle = 3;
        }
        if (style == 2) {
            this.makePlaneIndices();
            this.mPaintStyle = 4;
        }
    }

    private void makePlaneIndices() {
        this.mIndices = new short[this.mMajorSlices * this.mMinorSlices * 6];
        int j = 0;
        int i = 0;
        int counter = 0;
        for (i = 0; i < this.mMajorSlices; ++i) {
            for (j = 0; j < this.mMinorSlices; ++j) {
                this.mIndices[counter++] = (short)(i * (this.mMinorSlices + 1) + j);
                this.mIndices[counter++] = (short)(i * (this.mMinorSlices + 1) + j + 1);
                this.mIndices[counter++] = (short)((i + 1) * (this.mMinorSlices + 1) + j);
                this.mIndices[counter++] = (short)(i * (this.mMinorSlices + 1) + j + 1);
                this.mIndices[counter++] = (short)((i + 1) * (this.mMinorSlices + 1) + j + 1);
                this.mIndices[counter++] = (short)((i + 1) * (this.mMinorSlices + 1) + j);
            }
        }
        this.mIndexBuffer = this.allocate(this.mIndices);
        this.mTextureCoordinates = new float[(this.mMajorSlices + 1) * (this.mMinorSlices + 1) * 2];
        for (i = 0; i <= this.mMajorSlices; ++i) {
            for (j = 0; j <= this.mMinorSlices; ++j) {
                this.mTextureCoordinates[(i * (this.mMinorSlices + 1) + j) * 2] = (float)i / (float)this.mMajorSlices;
                this.mTextureCoordinates[(i * (this.mMinorSlices + 1) + j) * 2 + 1] = (float)j / (float)this.mMinorSlices;
            }
        }
        this.mTextureBuffer = this.allocate(this.mTextureCoordinates);
    }

    private void makeGridIndices() {
        int i;
        this.mIndices = new short[(this.mMajorSlices + 1) * (this.mMinorSlices + 1) * 2];
        int j = 0;
        for (i = 0; i < (this.mMajorSlices + 1) * (this.mMinorSlices + 1); ++i) {
            this.mIndices[j++] = (short)i;
        }
        for (i = 1; i < this.mMinorSlices; ++i) {
            for (int k = 0; k <= this.mMajorSlices; ++k) {
                this.mIndices[j++] = (short)(k * (this.mMinorSlices + 1) + i);
            }
        }
        this.mIndexBuffer = this.allocate(this.mIndices);
    }

    public void setTexture(Bitmap b, float scale) {
        super.setTexture(b);
        this.mTextureCoordinates = new float[(this.mMajorSlices + 1) * (this.mMinorSlices + 1) * 2];
        for (int i = 0; i <= this.mMajorSlices; ++i) {
            for (int j = 0; j <= this.mMinorSlices; ++j) {
                this.mTextureCoordinates[(i * (this.mMinorSlices + 1) + j) * 2] = scale * (float)i / (float)this.mMajorSlices;
                this.mTextureCoordinates[(i * (this.mMinorSlices + 1) + j) * 2 + 1] = (float)j / (float)this.mMinorSlices;
            }
        }
        this.mTextureBuffer = this.allocate(this.mTextureCoordinates);
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glFrontFace(2305);
        gl.glEnable(2884);
        gl.glCullFace(1029);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.mVertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.mNormalBuffer);
        gl.glDisableClientState(32886);
        if (this.mTexture != null && this.mTextureBuffer != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        gl.glDrawElements(this.mPaintStyle, this.mIndices.length, 5123, (Buffer)this.mIndexBuffer);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisable(2884);
    }
}

