/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import android.graphics.Bitmap;
import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLSquare
extends GLFigure {
    public int style;
    public int paintStyle;
    private static final float[] vertices = new float[]{-0.5f, 0.5f, 0.0f, -0.5f, -0.5f, 0.0f, 0.5f, -0.5f, 0.0f, 0.5f, 0.5f, 0.0f};
    protected float[] normals = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f};
    protected float[] textureCoordinates = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f};
    private short[] indices_plane = new short[]{0, 1, 2, 0, 2, 3};
    private short[] indices_grid = new short[]{0, 1, 2, 3, 0};
    private FloatBuffer vertexBuffer;
    private FloatBuffer colorBuffer;
    private ShortBuffer indexBuffer;
    private FloatBuffer mTextureBuffer;
    private FloatBuffer normalBuffer;
    private short[] indices;

    public GLSquare(int style) {
        super(style);
        this.style = style;
        if (style == 2) {
            this.paintStyle = 4;
            this.indices = this.indices_plane;
        } else if (style == 1) {
            this.paintStyle = 3;
            this.indices = this.indices_grid;
        }
        this.vertexBuffer = this.allocate(vertices);
        this.indexBuffer = this.allocate(this.indices);
        this.mTextureBuffer = this.allocate(this.textureCoordinates);
        this.normalBuffer = this.allocate(this.normals);
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glFrontFace(2305);
        gl.glDisable(2884);
        gl.glCullFace(1028);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        if (this.mTexture != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        if (this.colorBuffer != null) {
            this.mColor[2] = 1.0f;
            this.mColor[1] = 1.0f;
            this.mColor[0] = 1.0f;
            gl.glEnableClientState(32886);
            gl.glColorPointer(4, 5126, 0, (Buffer)this.colorBuffer);
        }
        gl.glDrawElements(this.paintStyle, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32886);
        gl.glDisableClientState(5890);
        gl.glDisableClientState(32885);
        gl.glDisableClientState(32884);
    }

    public void setTexture(Bitmap b, float scale) {
        super.setTexture(b);
        float[] texCoordinates = new float[this.textureCoordinates.length];
        for (int i = 0; i < this.textureCoordinates.length; ++i) {
            texCoordinates[i] = scale * this.textureCoordinates[i];
        }
        this.mTextureBuffer = this.allocate(texCoordinates);
    }

    public void setTexture(Bitmap b, float scaleX, float scaleY) {
        super.setTexture(b);
        float[] texCoordinates = new float[this.textureCoordinates.length];
        for (int i = 0; i < this.textureCoordinates.length; ++i) {
            texCoordinates[i] = i % 2 == 0 ? scaleX * this.textureCoordinates[i] : scaleY * this.textureCoordinates[i];
        }
        this.mTextureBuffer = this.allocate(texCoordinates);
    }

    public void setVertexColor(float[] colors) {
        if (colors == null) {
            this.colorBuffer = null;
        } else {
            if (colors.length != 16) {
                throw new IllegalArgumentException("length of color array for square must be 16");
            }
            this.colorBuffer = this.allocate(colors);
        }
    }
}

