/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import javax.microedition.khronos.opengles.GL10;

public class GLQuaternion {
    private float r;
    private float i;
    private float j;
    private float k;
    private float[] glRotate = new float[4];
    private boolean rotate;

    public GLQuaternion() {
        this(1.0f, 0.0f, 0.0f, 0.0f);
    }

    public GLQuaternion(float r, float i, float j, float k) {
        this.r = r;
        this.i = i;
        this.j = j;
        this.k = k;
    }

    public void add(GLQuaternion q) {
        this.r += q.r;
        this.i += q.i;
        this.j += q.j;
        this.k += q.k;
        this.calculateGlRotation();
    }

    public void multiply(float r_, float i_, float j_, float k_) {
        float _r = r_ * this.r - i_ * this.i - j_ * this.j - k_ * this.k;
        float _i = r_ * this.i + i_ * this.r + j_ * this.k - k_ * this.j;
        float _j = r_ * this.j - i_ * this.k + j_ * this.r + k_ * this.i;
        float _k = r_ * this.k + i_ * this.j - j_ * this.i + k_ * this.r;
        this.r = _r;
        this.i = _i;
        this.j = _j;
        this.k = _k;
        if (Float.isNaN(this.r) || Float.isNaN(this.i) || Float.isNaN(this.j) || Float.isNaN(this.k)) {
            this.einselement();
        }
        this.calculateGlRotation();
    }

    public void multiply(GLQuaternion q) {
        this.multiply(q.r, q.i, q.j, q.k);
    }

    public void rotateByAngleAxis(double angle, float x, float y, float z) {
        if (angle == 0.0) {
            return;
        }
        float length = (float)Math.sqrt(x * x + y * y + z * z);
        if (length == 0.0f) {
            return;
        }
        float sin_l = (float)Math.sin(angle / 2.0) / length;
        this.multiply((float)Math.cos(angle / 2.0), x * sin_l, y * sin_l, z * sin_l);
    }

    private void calculateGlRotation() {
        float scale = (float)Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        if (scale != 0.0f) {
            this.glRotate[0] = (float)(360.0 * Math.acos(this.r) / Math.PI);
            this.glRotate[1] = this.i / scale;
            this.glRotate[2] = this.j / scale;
            this.glRotate[3] = this.k / scale;
            this.rotate = true;
        } else {
            this.rotate = false;
        }
    }

    public void glRotate(GL10 gl) {
        if (this.rotate) {
            gl.glRotatef(this.glRotate[0], this.glRotate[1], this.glRotate[2], this.glRotate[3]);
        }
    }

    public void einselement() {
        this.r = 1.0f;
        this.i = 0.0f;
        this.j = 0.0f;
        this.k = 0.0f;
        this.calculateGlRotation();
    }

    public float[] toArray() {
        return new float[]{this.r, this.i, this.j, this.k};
    }

    public void loadArray(float[] array) {
        if (array.length != 4) {
            throw new IllegalArgumentException("arraylength must be equal to 4 for quaternions");
        }
        this.r = array[0];
        this.i = array[1];
        this.j = array[2];
        this.k = array[3];
        this.calculateGlRotation();
    }

    public void assign(GLQuaternion q) {
        this.r = q.r;
        this.i = q.i;
        this.j = q.j;
        this.k = q.k;
        this.calculateGlRotation();
    }
}

