/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.List;
import javax.microedition.khronos.opengles.GL10;

public class GLPolynom
extends GLFigure {
    private FloatBuffer vertexBuffer;
    private ShortBuffer indexBuffer;
    private short[] indices;
    private int lineWidth;

    public GLPolynom(List<GLPoint> points, int lineWidth) {
        super(1);
        int i;
        this.lineWidth = lineWidth;
        float[] vertices = new float[points.size() * 3 + 3];
        for (i = 0; i <= points.size(); ++i) {
            GLPoint point = points.get(i % points.size());
            vertices[3 * i + 0] = point.x;
            vertices[3 * i + 1] = point.y;
            vertices[3 * i + 2] = point.z;
        }
        this.indices = new short[points.size() + 1];
        for (i = 0; i <= points.size(); ++i) {
            this.indices[i] = (short)(i % points.size());
        }
        this.vertexBuffer = this.allocate(vertices);
        this.indexBuffer = this.allocate(this.indices);
        this.mColor[2] = 0.0f;
        this.mColor[1] = 0.0f;
        this.mColor[0] = 0.0f;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glLineWidth((float)this.lineWidth);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glDisableClientState(32886);
        gl.glDrawElements(3, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32884);
    }

    public static class GLPoint {
        public float x;
        public float y;
        public float z;
    }
}

