/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.opengl.GLUtils;
import de.neo.android.opengl.AbstractSceneRenderer;
import de.neo.android.opengl.figures.GLQuaternion;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.microedition.khronos.opengles.GL10;

public abstract class GLFigure {
    public static final int IDS_PER_COLOR = 19;
    public static final int STYLE_GRID = 1;
    public static final int STYLE_PLANE = 2;
    public static final int DRAW_MODE_NORMAL = 0;
    public static final int DRAW_MODE_PICK_ID = 1;
    private static int ID_COUNTER = 1;
    protected static List<GLFigure> allFigures = new ArrayList<GLFigure>();
    protected static Map<Bitmap, Integer> allTextures = new HashMap<Bitmap, Integer>();
    private int mDrawMode;
    public float[] mPosition = new float[]{0.0f, 0.0f, 0.0f};
    public float[] mSize = new float[]{1.0f, 1.0f, 1.0f};
    public GLQuaternion mRotation;
    public float[] mColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    private float[] mLightAmb = new float[4];
    private float[] mLightDif = new float[4];
    private float[] mLightSpe = new float[4];
    protected Bitmap mTexture;
    protected int[] mTextures;
    private final int mId = ++ID_COUNTER;
    private GLClickListener mClickListener;
    private GLClickListener mLongClickListener;
    protected int mStyle;

    public static void setFigureDrawMode(int draw_mode) {
        for (GLFigure f : allFigures) {
            f.mDrawMode = draw_mode;
        }
    }

    public GLFigure(int style) {
        this.mStyle = style;
        this.mRotation = new GLQuaternion();
        allFigures.add(this);
    }

    @SuppressLint(value={"WrongCall"})
    public final void draw(GL10 gl) {
        if (this.mDrawMode == 1 && this.mStyle == 1) {
            return;
        }
        gl.glPushMatrix();
        if (this.mTexture != null && this.mDrawMode == 0) {
            this.setTexture(gl);
        }
        if (this.mDrawMode == 0) {
            if (!AbstractSceneRenderer.mUseLighting) {
                gl.glColor4f(this.mColor[0], this.mColor[1], this.mColor[2], this.mColor[3]);
            } else {
                for (int i = 0; i < 4; ++i) {
                    this.mLightAmb[i] = this.mColor[i] * 0.4f;
                    this.mLightDif[i] = this.mColor[i] * 0.8f;
                    this.mLightSpe[i] = Math.min(this.mColor[i] * 1.2f, 1.0f);
                }
                gl.glLightfv(16384, 4608, this.mLightAmb, 0);
                gl.glLightfv(16384, 4609, this.mLightDif, 0);
                gl.glLightfv(16384, 4610, this.mLightSpe, 0);
            }
        } else {
            float r = (float)this.mId % 19.0f / 18.0f;
            int ir = (int)(r * 255.0f);
            float g = (float)(this.mId / 19) % 19.0f / 18.0f;
            int ig = (int)(g * 255.0f);
            float b = (float)(this.mId / 19 / 19) % 19.0f / 18.0f;
            int ib = (int)(b * 255.0f);
            GLFigure searchFigure = GLFigure.searchFigure(ir, ig, ib);
            if (this != searchFigure) {
                ++ir;
            }
            gl.glColor4f(r, g, b, 1.0f);
        }
        gl.glTranslatef(this.mPosition[0], this.mPosition[1], this.mPosition[2]);
        this.mRotation.glRotate(gl);
        gl.glScalef(this.mSize[0], this.mSize[1], this.mSize[2]);
        this.onDraw(gl);
        gl.glPopMatrix();
        if (this.mTexture != null) {
            gl.glDisableClientState(32888);
            gl.glDisable(3553);
        }
    }

    private void setTexture(GL10 gl) {
        if (this.mTextures == null) {
            this.loadTexture(gl);
        }
        gl.glEnable(3553);
        gl.glEnableClientState(32888);
        gl.glBindTexture(3553, this.mTextures[0]);
    }

    private void loadTexture(GL10 gl) {
        this.mTextures = new int[1];
        if (allTextures.containsKey(this.mTexture)) {
            this.mTextures[0] = allTextures.get(this.mTexture);
        } else {
            gl.glGenTextures(1, this.mTextures, 0);
            gl.glBindTexture(3553, this.mTextures[0]);
            gl.glTexParameterf(3553, 10241, 9729.0f);
            gl.glTexParameterf(3553, 10240, 9729.0f);
            gl.glTexParameterf(3553, 10243, 10497.0f);
            gl.glTexParameterf(3553, 10242, 10497.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)this.mTexture, (int)0);
            allTextures.put(this.mTexture, this.mTextures[0]);
        }
    }

    public void setTexture(Bitmap b) {
        this.mTexture = b;
        this.mTextures = null;
    }

    protected abstract void onDraw(GL10 var1);

    protected FloatBuffer allocate(float[] array) {
        ByteBuffer vbb = ByteBuffer.allocateDirect(array.length * 4);
        vbb.order(ByteOrder.nativeOrder());
        FloatBuffer buffer = vbb.asFloatBuffer();
        buffer.put(array);
        buffer.position(0);
        return buffer;
    }

    protected ShortBuffer allocate(short[] array) {
        ByteBuffer vbb = ByteBuffer.allocateDirect(array.length * 4);
        vbb.order(ByteOrder.nativeOrder());
        ShortBuffer buffer = vbb.asShortBuffer();
        buffer.put(array);
        buffer.position(0);
        return buffer;
    }

    protected FloatBuffer allocateFloat(int size) {
        ByteBuffer vbb = ByteBuffer.allocateDirect(size);
        vbb.order(ByteOrder.nativeOrder());
        FloatBuffer buffer = vbb.asFloatBuffer();
        buffer.position(0);
        return buffer;
    }

    public void setOnClickListener(GLClickListener listener) {
        this.mClickListener = listener;
    }

    public void setOnLongClickListener(GLClickListener listener) {
        this.mLongClickListener = listener;
    }

    public static GLFigure searchFigure(int red, int green, int blue) {
        for (GLFigure figure : allFigures) {
            float r = (float)figure.mId % 19.0f / 18.0f;
            float g = (float)(figure.mId / 19) % 19.0f / 18.0f;
            float b = (float)(figure.mId / 19 / 19) % 19.0f / 18.0f;
            if (!(Math.abs(256.0f * r - (float)red) < 6.3333335f) || !(Math.abs(256.0f * g - (float)green) < 6.3333335f) || !(Math.abs(256.0f * b - (float)blue) < 6.3333335f)) continue;
            return figure;
        }
        return null;
    }

    public GLClickListener getOnClickListener() {
        return this.mClickListener;
    }

    public GLClickListener getOnLongClickListener() {
        return this.mLongClickListener;
    }

    public int getID() {
        return this.mId;
    }

    public static void reloadTextures() {
        allTextures.clear();
        for (GLFigure figure : allFigures) {
            figure.mTextures = null;
        }
    }

    public static interface GLClickListener {
        public void onGLClick();
    }
}

