/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl.figures;

import de.neo.android.opengl.figures.GLFigure;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;

public class GLBoxplate
extends GLFigure {
    private ShortBuffer indexBuffer;
    private FloatBuffer mTextureBuffer;
    private short[] indices;
    private float[] vertex;
    private float[] textureCoordinates;
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private int drawStyle;

    public GLBoxplate(int parts, float y1, float r1, float y2, float r2) {
        super(2);
        int i;
        this.vertex = new float[(2 * parts + 6) * 3];
        float[] normal = new float[(2 * parts + 6) * 3];
        float steps = (float)(Math.PI * 2 / (double)parts);
        for (i = 0; i < parts; ++i) {
            float sin = (float)Math.sin((float)i * steps);
            float cos = (float)Math.cos((float)i * steps);
            this.vertex[i * 3 + 0] = sin * r1;
            this.vertex[i * 3 + 1] = cos * r1 + y1;
            this.vertex[i * 3 + 2] = 0.0f;
            this.vertex[(i + parts) * 3 + 0] = sin * r2;
            this.vertex[(i + parts) * 3 + 1] = cos * r2 + y2;
            this.vertex[(i + parts) * 3 + 2] = 0.0f;
        }
        this.vertex[parts * 6 + 0] = 0.25f;
        this.vertex[parts * 6 + 1] = 1.0f;
        this.vertex[parts * 6 + 2] = 0.0f;
        this.vertex[parts * 6 + 3] = 0.25f;
        this.vertex[parts * 6 + 4] = 0.5f;
        this.vertex[parts * 6 + 5] = 0.0f;
        this.vertex[parts * 6 + 6] = 0.25f;
        this.vertex[parts * 6 + 7] = 0.0f;
        this.vertex[parts * 6 + 8] = 0.0f;
        this.vertex[parts * 6 + 9] = -0.25f;
        this.vertex[parts * 6 + 10] = 0.0f;
        this.vertex[parts * 6 + 11] = 0.0f;
        this.vertex[parts * 6 + 12] = -0.25f;
        this.vertex[parts * 6 + 13] = 0.5f;
        this.vertex[parts * 6 + 14] = 0.0f;
        this.vertex[parts * 6 + 15] = -0.25f;
        this.vertex[parts * 6 + 16] = 1.0f;
        this.vertex[parts * 6 + 17] = 0.0f;
        for (i = 0; i < 2 * parts + 6; ++i) {
            normal[i * 3 + 0] = 0.0f;
            normal[i * 3 + 1] = 0.0f;
            normal[i * 3 + 2] = 1.0f;
        }
        this.createPlaneIndices(parts, y1, r1, y2, r2);
        this.vertexBuffer = this.allocate(this.vertex);
        this.normalBuffer = this.allocate(normal);
        this.indexBuffer = this.allocate(this.indices);
    }

    private void createPlaneIndices(int parts, float y1, float r1, float y2, float r2) {
        this.indices = new short[(2 * parts + 8) * 3];
        this.indices[0] = (short)parts;
        for (int i = 0; i < parts; ++i) {
            this.indices[i * 3 + 0] = (short)i;
            this.indices[i * 3 + 1] = (short)(parts * 2 + 4 * i / parts + 1);
            this.indices[i * 3 + 2] = (short)((i + 1) % parts);
            int border = 4 * i / parts;
            this.indices[(i + parts) * 3 + 0] = (short)(i + parts);
            this.indices[(i + parts) * 3 + 1] = (short)(parts * 2 + (border < 2 ? border : border + 2));
            this.indices[(i + parts) * 3 + 2] = (short)(parts + (i + 1) % parts);
        }
        this.indices[parts * 6 + 0] = (short)(2 * parts + 5);
        this.indices[parts * 6 + 1] = (short)(2 * parts + 0);
        this.indices[parts * 6 + 2] = (short)parts;
        this.indices[parts * 6 + 3] = (short)(2 * parts + 0);
        this.indices[parts * 6 + 4] = (short)(2 * parts + 1);
        this.indices[parts * 6 + 5] = (short)(parts + parts / 4);
        this.indices[parts * 6 + 6] = (short)(2 * parts + 1);
        this.indices[parts * 6 + 7] = (short)(2 * parts + 4);
        this.indices[parts * 6 + 8] = (short)(parts + 2 * parts / 4);
        this.indices[parts * 6 + 9] = (short)(2 * parts + 4);
        this.indices[parts * 6 + 10] = (short)(2 * parts + 5);
        this.indices[parts * 6 + 11] = (short)(parts + 3 * parts / 4);
        this.indices[parts * 6 + 12] = (short)(2 * parts + 4);
        this.indices[parts * 6 + 13] = (short)(2 * parts + 1);
        this.indices[parts * 6 + 14] = 0;
        this.indices[parts * 6 + 15] = (short)(2 * parts + 1);
        this.indices[parts * 6 + 16] = (short)(2 * parts + 2);
        this.indices[parts * 6 + 17] = (short)(0 + parts / 4);
        this.indices[parts * 6 + 18] = (short)(2 * parts + 2);
        this.indices[parts * 6 + 19] = (short)(2 * parts + 3);
        this.indices[parts * 6 + 20] = (short)(0 + 2 * parts / 4);
        this.indices[parts * 6 + 21] = (short)(2 * parts + 3);
        this.indices[parts * 6 + 22] = (short)(2 * parts + 4);
        this.indices[parts * 6 + 23] = (short)(0 + 3 * parts / 4);
        this.textureCoordinates = new float[(2 * parts + 6) * 2];
        float steps = (float)(Math.PI * 2 / (double)parts);
        for (int i = 0; i < parts; ++i) {
            this.textureCoordinates[i * 2 + 0] = (float)(0.5 + (double)(r1 * 2.0f) * Math.sin(steps * (float)i));
            this.textureCoordinates[i * 2 + 1] = (float)((double)y1 + (double)r1 * Math.cos(steps * (float)i));
            this.textureCoordinates[(i + parts) * 2 + 0] = (float)(0.5 + (double)(r2 * 2.0f) * Math.sin(steps * (float)i));
            this.textureCoordinates[(i + parts) * 2 + 1] = (float)((double)y2 + (double)r2 * Math.cos(steps * (float)i));
        }
        this.textureCoordinates[parts * 4 + 0] = 1.0f;
        this.textureCoordinates[parts * 4 + 1] = 1.0f;
        this.textureCoordinates[parts * 4 + 2] = 1.0f;
        this.textureCoordinates[parts * 4 + 3] = 0.5f;
        this.textureCoordinates[parts * 4 + 4] = 1.0f;
        this.textureCoordinates[parts * 4 + 5] = 0.0f;
        this.textureCoordinates[parts * 4 + 6] = 0.0f;
        this.textureCoordinates[parts * 4 + 7] = 0.0f;
        this.textureCoordinates[parts * 4 + 8] = 0.0f;
        this.textureCoordinates[parts * 4 + 9] = 0.5f;
        this.textureCoordinates[parts * 4 + 10] = 0.0f;
        this.textureCoordinates[parts * 4 + 11] = 1.0f;
        this.mTextureBuffer = this.allocate(this.textureCoordinates);
        this.drawStyle = 4;
    }

    @Override
    protected void onDraw(GL10 gl) {
        gl.glFrontFace(2305);
        gl.glCullFace(1028);
        gl.glEnable(2884);
        gl.glEnableClientState(32884);
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gl.glEnableClientState(32885);
        gl.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        gl.glDisableClientState(32886);
        if (this.mTexture != null && this.mTextureBuffer != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.mTextureBuffer);
        }
        gl.glDrawElements(this.drawStyle, this.indices.length, 5123, (Buffer)this.indexBuffer);
        gl.glDisableClientState(32885);
        gl.glDisableClientState(32884);
        gl.glDisable(2884);
    }
}

