/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import de.neo.android.opengl.AbstractSceneRenderer;
import de.neo.android.opengl.figures.GLFigure;

public class AbstractSceneSurfaceView
extends GLSurfaceView {
    private AbstractSceneRenderer mRenderer;
    private float mDownX;
    private float mDownY;
    private long mMouseDownTime;

    public AbstractSceneSurfaceView(Context context, Bundle savedInstanceState, AbstractSceneRenderer renderer) {
        super(context);
        this.mRenderer = renderer;
        if (savedInstanceState != null) {
            this.mRenderer.onLoadBundle(savedInstanceState);
        }
        this.setRenderer(this.mRenderer);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mRenderer.onTouchEvent(event);
        super.onTouchEvent(event);
        if (event.getAction() == 0) {
            this.mDownX = event.getX();
            this.mDownY = event.getY();
            this.mMouseDownTime = System.currentTimeMillis();
        }
        if (event.getAction() == 1 && Math.abs(event.getX() - this.mDownX) < 8.0f && Math.abs(event.getY() - this.mDownY) < 8.0f) {
            this.mRenderer.selectFigure((int)event.getX(), (int)event.getY(), (View)this);
            this.mRenderer.setLongClick(System.currentTimeMillis() - this.mMouseDownTime > 500L);
        }
        return true;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mRenderer.onSaveInstanceState(outState);
    }

    public void onResume() {
        super.onResume();
        GLFigure.reloadTextures();
    }
}

