/*
 * Decompiled with CFR 0.152.
 */
package de.neo.android.opengl;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import android.os.Bundle;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import de.neo.android.opengl.figures.GLFigure;
import de.neo.android.opengl.figures.GLSquare;
import de.neo.android.opengl.touchhandler.RotateSceneHandler;
import de.neo.android.opengl.touchhandler.TouchSceneHandler;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public abstract class AbstractSceneRenderer
implements GLSurfaceView.Renderer {
    public static boolean mUseLighting = true;
    public GLFigure mScene;
    protected SparseArray<Bitmap> mTextureMap;
    public Thread mGLThread;
    private boolean mSelectObject;
    private int mSelectX;
    private int mSelectY;
    private View mView;
    private GLSquare mGradient;
    private TouchSceneHandler mTouchSceneHandler;
    protected Context mContext;
    private float mScreenRatio;
    private boolean mLongClick;

    public AbstractSceneRenderer(Context context) {
        this.mContext = context;
        this.mScene = this.createScene();
        this.setTouchSceneHandler(new RotateSceneHandler());
        this.setLighting(true);
    }

    protected abstract GLFigure createScene();

    protected void setLighting(boolean b) {
        mUseLighting = b;
    }

    public void onDrawFrame(GL10 gl) {
        if (this.mSelectObject) {
            this.selectObject(gl, this.mSelectX, this.mSelectY);
            this.mSelectObject = false;
        }
        this.renderScene(gl, 1.0f, 1.0f, 1.0f);
    }

    private void renderScene(GL10 gl, float red, float green, float blue) {
        gl.glClear(16640);
        gl.glClearColor(red, green, blue, 0.0f);
        if (this.mGradient != null) {
            gl.glDisable(2929);
            gl.glDisable(2896);
            gl.glLoadIdentity();
            gl.glTranslatef(0.0f, 0.0f, -1.2f);
            this.mGradient.draw(gl);
            gl.glEnable(2929);
        }
        gl.glLoadIdentity();
        this.mTouchSceneHandler.glTransformScene(gl);
        gl.glLineWidth(1.0f);
        if (mUseLighting && !this.mSelectObject) {
            gl.glEnable(2896);
        }
        this.mScene.draw(gl);
    }

    private void selectObject(GL10 gl, int selectX, int selectY) {
        GLFigure.setFigureDrawMode(1);
        gl.glDisable(2896);
        this.renderScene(gl, 1.0f, 1.0f, 1.0f);
        int color = this.getColorAtPixel(gl, selectX, selectY);
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        GLFigure figure = GLFigure.searchFigure(red, green, blue);
        if (figure != null) {
            Log.e((String)"Figure found", (String)("found figure: " + figure.getClass().getSimpleName() + " (" + figure.getID() + ")"));
            this.onFigureTouched(gl, figure);
        } else {
            this.onNoFigureTouched(gl);
        }
        GLFigure.setFigureDrawMode(0);
    }

    protected void onFigureTouched(GL10 gl, GLFigure figure) {
        if (!this.mLongClick && figure.getOnClickListener() != null) {
            figure.getOnClickListener().onGLClick();
        }
        if (this.mLongClick && figure.getOnLongClickListener() != null) {
            figure.getOnLongClickListener().onGLClick();
        }
    }

    protected void onNoFigureTouched(GL10 gl) {
    }

    protected void setGradient(float[] bottom, float[] top) {
        if (this.mGradient == null) {
            this.mGradient = new GLSquare(2);
        }
        float[] colors = new float[16];
        for (int i = 0; i < 4; ++i) {
            colors[i + 0] = top[i];
            colors[i + 4] = bottom[i];
            colors[i + 8] = bottom[i];
            colors[i + 12] = top[i];
        }
        this.mGradient.setVertexColor(colors);
    }

    protected void setGradient(Bitmap b) {
        if (this.mGradient == null) {
            this.mGradient = new GLSquare(2);
        }
        this.mGradient.setTexture(b);
    }

    protected void setTouchSceneHandler(TouchSceneHandler handler) {
        this.mTouchSceneHandler = handler;
    }

    protected int getColorAtPixel(GL10 gl, int sx, int sy) {
        int h = this.mView.getHeight();
        int[] b = new int[4];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        gl.glReadPixels(sx, h - sy - 1, 1, 1, 6408, 5121, (Buffer)ib);
        int pix = b[0];
        int pb = pix >> 16 & 0xFF;
        int pr = pix << 16 & 0xFF0000;
        int color = pix & 0xFF00FF00 | pr | pb;
        return color;
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.mScreenRatio = (float)width / (float)height;
        if (this.mGradient != null) {
            this.mGradient.mSize[0] = this.mScreenRatio;
        }
        GLU.gluPerspective((GL10)gl, (float)45.0f, (float)this.mScreenRatio, (float)0.1f, (float)100.0f);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        gl.glClearColor(0.0f, 0.0f, 0.0f, 0.5f);
        gl.glShadeModel(7425);
        gl.glClearDepthf(1.0f);
        gl.glEnable(2929);
        gl.glDepthFunc(515);
        float[] matSpecular = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] matShininess = new float[]{5.0f};
        float[] matAmbient = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] matDiffuse = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        float[] light_position = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        gl.glMaterialfv(1028, 4610, matSpecular, 0);
        gl.glMaterialfv(1028, 5633, matShininess, 0);
        gl.glMaterialfv(1028, 4608, matAmbient, 0);
        gl.glMaterialfv(1028, 4609, matDiffuse, 0);
        gl.glLightfv(16384, 4611, light_position, 0);
        gl.glEnable(16384);
    }

    public void onTouchEvent(MotionEvent event) {
        this.mTouchSceneHandler.onTouchEvent(event);
    }

    protected Bitmap loadBitmap(int id) {
        if (this.mTextureMap == null) {
            this.mTextureMap = new SparseArray();
        }
        if (this.mTextureMap.indexOfKey(id) > 0) {
            return (Bitmap)this.mTextureMap.get(id);
        }
        Matrix flip = new Matrix();
        flip.postScale(1.0f, -1.0f);
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inScaled = false;
        Bitmap b = BitmapFactory.decodeResource((Resources)this.mContext.getResources(), (int)id, (BitmapFactory.Options)opts);
        Bitmap bitmap = Bitmap.createBitmap((Bitmap)b, (int)0, (int)0, (int)b.getWidth(), (int)b.getHeight(), (Matrix)flip, (boolean)true);
        b.recycle();
        this.mTextureMap.put(id, (Object)bitmap);
        return bitmap;
    }

    public void onSaveInstanceState(Bundle outState) {
        this.mTouchSceneHandler.onSaveInstanceState(outState);
    }

    public void onLoadBundle(Bundle bundle) {
        this.mTouchSceneHandler.onLoadBundle(bundle);
    }

    public void selectFigure(int x, int y, View view) {
        this.mSelectObject = true;
        this.mSelectX = x;
        this.mSelectY = y;
        this.mView = view;
    }

    protected Bitmap loadBitmapFromView(GL10 gl) {
        int x = 0;
        int y = 0;
        int w = this.mView.getWidth();
        int h = this.mView.getHeight();
        int[] b = new int[w * h];
        int[] bt = new int[w * h];
        IntBuffer ib = IntBuffer.wrap(b);
        ib.position(0);
        gl.glReadPixels(x, y, w, h, 6408, 5121, (Buffer)ib);
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                int pix1;
                int pix = b[i * w + j];
                int pb = pix >> 16 & 0xFF;
                int pr = pix << 16 & 0xFF0000;
                bt[(h - i - 1) * w + j] = pix1 = pix & 0xFF00FF00 | pr | pb;
            }
        }
        Bitmap sb = Bitmap.createBitmap((int[])bt, (int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        return sb;
    }

    public void setLongClick(boolean longClick) {
        this.mLongClick = longClick;
    }
}

