/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.renderer;

import brainslug.flow.node.ChoiceDefinition;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.JoinDefinition;
import brainslug.flow.node.MergeDefinition;
import brainslug.flow.node.ParallelDefinition;
import brainslug.flow.node.marker.EndEvent;
import brainslug.flow.node.marker.IntermediateEvent;
import brainslug.flow.node.marker.StartEvent;
import brainslug.flow.node.task.AbstractTaskDefinition;
import brainslug.flow.renderer.ShapeInfo;
import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxIShape;
import com.mxgraph.shape.mxStencilShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxStylesheet;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Scanner;

public abstract class Skin {
    private List<ShapeInfo> shapes = new ArrayList<ShapeInfo>();
    int defaultNodeSize = 30;

    public mxGraph apply(mxGraph graph) {
        this.setupStyleSheets(graph);
        return graph;
    }

    public String getShape(FlowNodeDefinition<?> node) {
        if (node instanceof AbstractTaskDefinition) {
            return "Rounded";
        }
        if (node instanceof ChoiceDefinition) {
            return "Gateway-Exclusive";
        }
        if (node instanceof MergeDefinition) {
            return "Gateway-Exclusive";
        }
        if (node instanceof JoinDefinition) {
            return "Gateway-Parallel";
        }
        if (node instanceof ParallelDefinition) {
            return "Gateway-Parallel";
        }
        if (node.hasMixin(EndEvent.class)) {
            return "End-Event";
        }
        if (node.hasMixin(StartEvent.class)) {
            return "Start-Event";
        }
        if (node.hasMixin(IntermediateEvent.class)) {
            return "Intermediate-Event";
        }
        throw new IllegalArgumentException("no style definition available for " + node);
    }

    public mxRectangle getNodeSize(FlowNodeDefinition<?> node) {
        if (node instanceof AbstractTaskDefinition) {
            return new mxRectangle(0.0, 0.0, 70.0, 45.0);
        }
        return new mxRectangle(0.0, 0.0, (double)this.defaultNodeSize, (double)this.defaultNodeSize);
    }

    public void loadShapes(List<ShapeInfo> shapes) {
        this.shapes = shapes;
        for (ShapeInfo shape : shapes) {
            String shapeXml = this.convertStreamToString(this.getClass().getClassLoader().getResourceAsStream(shape.getLocation()));
            this.addStencilShape(shape.getName(), shapeXml);
        }
    }

    public void addStencilShape(String name, String shapeXml) {
        int lessthanIndex = shapeXml.indexOf("<");
        shapeXml = shapeXml.substring(lessthanIndex);
        mxStencilShape newShape = new mxStencilShape(shapeXml);
        mxGraphics2DCanvas.putShape((String)name, (mxIShape)newShape);
    }

    private void setupStyleSheets(mxGraph graph) {
        mxStylesheet stylesheet = graph.getStylesheet();
        stylesheet.getDefaultVertexStyle().put(mxConstants.STYLE_FILLCOLOR, "#FFFFFF");
        stylesheet.getDefaultVertexStyle().put(mxConstants.STYLE_STROKECOLOR, "#000000");
        stylesheet.getDefaultVertexStyle().put(mxConstants.STYLE_FONTCOLOR, "#000000");
        stylesheet.getDefaultEdgeStyle().put(mxConstants.STYLE_STROKECOLOR, "#000000");
        stylesheet.getDefaultEdgeStyle().put(mxConstants.STYLE_FONTCOLOR, "#000000");
        this.addStyles(stylesheet);
    }

    private void addStyles(mxStylesheet stylesheet) {
        stylesheet.putCellStyle("Rounded", this.roundedRectangleStyle());
        for (ShapeInfo shape : this.shapes) {
            stylesheet.putCellStyle(shape.getName(), shape.getStyle());
        }
    }

    protected Hashtable<String, Object> roundedRectangleStyle() {
        Hashtable<String, Object> roundedStyle = new Hashtable<String, Object>();
        roundedStyle.put(mxConstants.STYLE_SHAPE, "rectangle");
        roundedStyle.put(mxConstants.STYLE_ROUNDED, true);
        roundedStyle.put(mxConstants.STYLE_WHITE_SPACE, "wrap");
        return roundedStyle;
    }

    protected Hashtable<String, Object> shapeStyle() {
        Hashtable<String, Object> shapeStyle = new Hashtable<String, Object>();
        shapeStyle.put(mxConstants.STYLE_SPACING_BOTTOM, -mxConstants.DEFAULT_FONTSIZE * 2);
        shapeStyle.put(mxConstants.STYLE_VERTICAL_ALIGN, "bottom");
        return shapeStyle;
    }

    private String convertStreamToString(InputStream is) {
        Scanner s = new Scanner(is).useDelimiter("\\A");
        return s.hasNext() ? s.next() : "";
    }
}

