/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.model;

import brainslug.flow.model.AbstractTaskDefinition;
import brainslug.flow.model.AndDefinition;
import brainslug.flow.model.ChoiceDefinition;
import brainslug.flow.model.EventDefinition;
import brainslug.flow.model.FlowDefinition;
import brainslug.flow.model.FlowNodeDefinition;
import brainslug.flow.model.Identifier;
import brainslug.flow.model.ParallelDefinition;
import brainslug.flow.model.marker.EndEvent;
import brainslug.flow.model.marker.IntermediateEvent;
import java.util.LinkedList;

public class FlowPathDefinition<T extends FlowPathDefinition> {
    final FlowDefinition definition;
    FlowNodeDefinition startNode;
    LinkedList<FlowNodeDefinition> pathNodes = new LinkedList();

    public FlowPathDefinition(FlowDefinition definition, FlowNodeDefinition startNode) {
        this.definition = definition;
        this.startNode = startNode;
        startNode.setFlowPathDefinition(this);
    }

    public ChoiceDefinition choice(Identifier id) {
        return (ChoiceDefinition)((ChoiceDefinition)this.appendNode(new ChoiceDefinition(this)).id(id)).self();
    }

    public AndDefinition parallel(Identifier id) {
        return ((ParallelDefinition)((ParallelDefinition)this.appendNode(new ParallelDefinition(this).id(id))).self()).fork();
    }

    public T execute(AbstractTaskDefinition taskDefinition) {
        this.appendNode(taskDefinition);
        return this.then();
    }

    public T waitFor(EventDefinition eventDefinition) {
        eventDefinition.with(new IntermediateEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    public T end(FlowNodeDefinition<EventDefinition> eventDefinition) {
        eventDefinition.with(new EndEvent());
        this.appendNode(eventDefinition);
        return this.then();
    }

    private <T extends FlowNodeDefinition> T appendNode(T flowNodeDefinition) {
        if (this.definition.getNodes().contains(flowNodeDefinition)) {
            throw new IllegalStateException("Node already exists");
        }
        this.definition.addNode(flowNodeDefinition);
        this.connectToStartOrPath(flowNodeDefinition);
        flowNodeDefinition.setFlowPathDefinition(this);
        this.pathNodes.add(flowNodeDefinition);
        return flowNodeDefinition;
    }

    private <T extends FlowNodeDefinition> void connectToStartOrPath(T flowNodeDefinition) {
        if (this.pathNodes.isEmpty()) {
            this.connect(this.startNode, flowNodeDefinition);
        } else {
            this.connect(this.pathNodes.getLast(), flowNodeDefinition);
        }
    }

    private <T extends FlowNodeDefinition> void connect(FlowNodeDefinition previousNode, T flowNodeDefinition) {
        previousNode.addOutgoing(flowNodeDefinition);
        flowNodeDefinition.addIncoming(previousNode);
    }

    public T then() {
        return (T)this;
    }

    public LinkedList<FlowNodeDefinition> getPathNodes() {
        return this.pathNodes;
    }
}

