/*
 * Decompiled with CFR 0.152.
 */
package brainslug.maven;

import brainslug.bpmn.BpmnModelTransformer;
import brainslug.flow.builder.FlowBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.List;
import org.activiti.bpmn.BpmnAutoLayout;
import org.activiti.bpmn.model.BpmnModel;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="export-bpmn", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class ExportBpmnMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="project.compileClasspathElements", required=true, readonly=true)
    private List<String> classpath;
    @Parameter(required=true)
    private String flows;
    @Parameter(required=false)
    private String outputDir = "flows";

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String flowName : this.flows.split(",")) {
            FlowBuilder flowBuilder = this.createFlowInstance(flowName.trim(), this.setupClassPath());
            this.exportBpmn(flowBuilder, this.getFileOutputStream(this.getOutputFile(this.flows + "." + "bpmn")));
        }
    }

    private void exportBpmn(FlowBuilder flowBuilder, FileOutputStream fileOutputStream) {
        BpmnModelTransformer bpmnModelTransformer = new BpmnModelTransformer();
        BpmnModel bpmnModel = bpmnModelTransformer.toBpmnModel(flowBuilder);
        new BpmnAutoLayout(bpmnModel).execute();
        String bpmnXml = bpmnModelTransformer.toBpmnXml(bpmnModel);
        this.writeToFile(fileOutputStream, bpmnXml);
    }

    private void writeToFile(FileOutputStream fileOutputStream, String bpmnXml) {
        try {
            fileOutputStream.write(bpmnXml.getBytes("UTF-8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                fileOutputStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private FlowBuilder createFlowInstance(String flowName, ClassLoader classLoader) {
        try {
            Class<?> flowClass = Class.forName(flowName, true, classLoader);
            try {
                return (FlowBuilder)flowClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("unable to find flow with name: " + flowName, e);
        }
    }

    private File getOutputFile(String fileName) {
        return new File(this.getOutputDirectory().getAbsolutePath() + File.separatorChar + fileName);
    }

    private File getOutputDirectory() {
        File outputDirectory = new File(this.project.getBuild().getDirectory() + File.separatorChar + this.outputDir);
        outputDirectory.mkdirs();
        return outputDirectory;
    }

    private FileOutputStream getFileOutputStream(File outputFile) {
        try {
            return new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(outputFile + " is a invalid path.");
        }
    }

    ClassLoader setupClassPath() {
        try {
            HashSet<URL> urls = new HashSet<URL>();
            for (String element : this.classpath) {
                urls.add(new File(element).toURI().toURL());
            }
            URLClassLoader contextClassLoader = URLClassLoader.newInstance(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            return contextClassLoader;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

