/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.definition.FlowDefinition;
import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.async.AsyncFlowStartScheduler;
import brainslug.flow.execution.async.SchedulerOptions;
import brainslug.flow.node.FlowNodeDefinition;
import brainslug.flow.node.event.StartEvent;
import brainslug.flow.node.event.timer.StartTimerDefinition;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceFlowStartScheduler
implements AsyncFlowStartScheduler {
    private BrainslugContext context;
    private List<TimedFlowDefinition> timedDefinitions = new CopyOnWriteArrayList<TimedFlowDefinition>();
    private Map<Identifier, Long> lastStart = new ConcurrentHashMap<Identifier, Long>();
    ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
    SchedulerOptions schedulerOptions;
    ScheduledFuture<?> scheduledFuture;

    @Override
    public synchronized void start(SchedulerOptions schedulerOptions, BrainslugContext brainslugContext, Collection<FlowDefinition> definitions) {
        this.schedulerOptions = schedulerOptions;
        this.context = brainslugContext;
        this.addFlowDefinitionsWithStartTimer(definitions);
        this.startScheduler();
    }

    private void startScheduler() {
        this.scheduledFuture = this.scheduledExecutorService.scheduleAtFixedRate(new StartDueDefinitionsRunnable(), this.schedulerOptions.getScheduleDelay(), this.schedulerOptions.getSchedulePeriod(), this.schedulerOptions.getScheduleUnit());
    }

    @Override
    public synchronized void stop() {
        if (this.scheduledFuture != null && !this.scheduledFuture.isDone()) {
            this.scheduledFuture.cancel(false);
        }
    }

    public List<TimedFlowDefinition> addFlowDefinitionsWithStartTimer(Collection<FlowDefinition> definitions) {
        for (FlowDefinition definition : definitions) {
            for (FlowNodeDefinition node : definition.getNodes()) {
                if (!node.is(StartEvent.class) || !((StartEvent)node.as(StartEvent.class)).getStartTimerDefinition().isPresent()) continue;
                this.timedDefinitions.add(new TimedFlowDefinition(definition, (StartTimerDefinition)((StartEvent)node.as(StartEvent.class)).getStartTimerDefinition().get(), node));
            }
        }
        return this.timedDefinitions;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public ExecutorServiceFlowStartScheduler withScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public SchedulerOptions getSchedulerOptions() {
        return this.schedulerOptions;
    }

    public ExecutorServiceFlowStartScheduler withSchedulerOptions(SchedulerOptions schedulerOptions) {
        this.schedulerOptions = schedulerOptions;
        return this;
    }

    public List<TimedFlowDefinition> getTimedDefinitions() {
        return this.timedDefinitions;
    }

    class StartDueDefinitionsRunnable
    implements Runnable {
        Logger log = LoggerFactory.getLogger(StartDueDefinitionsRunnable.class);

        StartDueDefinitionsRunnable() {
        }

        @Override
        public void run() {
            this.log.debug("checking for due flows...");
            try {
                for (TimedFlowDefinition definition : ExecutorServiceFlowStartScheduler.this.timedDefinitions) {
                    this.startFlowIfDue(definition);
                }
            }
            catch (Exception timedStartException) {
                this.log.error("error during while starting timed definitions", (Throwable)timedStartException);
            }
        }

        private void startFlowIfDue(TimedFlowDefinition definition) {
            try {
                if (this.isDue(definition)) {
                    ExecutorServiceFlowStartScheduler.this.context.startFlow(definition.getFlowDefinition().getId(), definition.getStartNode().getId());
                    ExecutorServiceFlowStartScheduler.this.lastStart.put(definition.getFlowDefinition().getId(), new Date().getTime());
                }
            }
            catch (Exception exceptionDuringStart) {
                this.log.error("error during start of " + definition.getFlowDefinition().getName(), (Throwable)exceptionDuringStart);
            }
        }

        boolean isDue(TimedFlowDefinition definition) {
            Long lastStartTime = (Long)ExecutorServiceFlowStartScheduler.this.lastStart.get(definition.getFlowDefinition().getId());
            if (lastStartTime == null) {
                return true;
            }
            StartTimerDefinition timerDefinition = definition.getStartTimerDefinition();
            return new Date().getTime() > lastStartTime + timerDefinition.getUnit().toMillis(timerDefinition.getDuration());
        }
    }

    class TimedFlowDefinition {
        FlowDefinition flowDefinition;
        StartTimerDefinition startTimerDefinition;
        FlowNodeDefinition startNode;

        TimedFlowDefinition(FlowDefinition flowDefinition, StartTimerDefinition startTimerDefinition, FlowNodeDefinition startNode) {
            this.flowDefinition = flowDefinition;
            this.startTimerDefinition = startTimerDefinition;
            this.startNode = startNode;
        }

        public FlowDefinition getFlowDefinition() {
            return this.flowDefinition;
        }

        public StartTimerDefinition getStartTimerDefinition() {
            return this.startTimerDefinition;
        }

        public FlowNodeDefinition getStartNode() {
            return this.startNode;
        }
    }
}

