/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.definition.Identifier;
import brainslug.flow.execution.async.AsyncTriggerErrorDetails;
import brainslug.util.IdUtil;
import brainslug.util.Option;

public class AsyncTrigger {
    Identifier id;
    Identifier nodeId;
    Identifier instanceId;
    Identifier definitionId;
    long createdDate = 0L;
    long dueDate = 0L;
    long retries = 0L;
    long maxRetries = 5L;
    long version = 0L;
    AsyncTriggerErrorDetails errorDetails;

    public AsyncTrigger() {
    }

    public AsyncTrigger(String id, String nodeId, String instanceId, String definitionId, Long createdDate, Long dueDate, Long retries, Long maxRetries, Long version) {
        this.id = IdUtil.id((String)id);
        this.nodeId = IdUtil.id((String)nodeId);
        this.instanceId = IdUtil.id((String)instanceId);
        this.definitionId = IdUtil.id((String)definitionId);
        this.createdDate = createdDate;
        this.dueDate = dueDate;
        this.retries = retries;
        this.maxRetries = maxRetries;
        this.version = version;
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    public AsyncTrigger withNodeId(Identifier taskNodeId) {
        this.nodeId = taskNodeId;
        return this;
    }

    public Identifier getInstanceId() {
        return this.instanceId;
    }

    public AsyncTrigger withInstanceId(Identifier instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public Identifier getDefinitionId() {
        return this.definitionId;
    }

    public AsyncTrigger withDefinitionId(Identifier definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public AsyncTrigger withDueDate(long dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public long getRetries() {
        return this.retries;
    }

    public AsyncTrigger incrementRetries() {
        ++this.retries;
        return this;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    public AsyncTrigger withMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AsyncTrigger incrementVersion() {
        ++this.version;
        return this;
    }

    public AsyncTrigger withVersion(long version) {
        this.version = version;
        return this;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public AsyncTrigger withCreatedDate(long createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public Option<AsyncTriggerErrorDetails> getErrorDetails() {
        return Option.of((Object)this.errorDetails);
    }

    public AsyncTrigger withErrorDetails(AsyncTriggerErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public Option<Identifier> getId() {
        return Option.of((Object)this.id);
    }

    public AsyncTrigger withId(Identifier id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncTrigger asyncTrigger = (AsyncTrigger)o;
        if (this.id != asyncTrigger.id) {
            return false;
        }
        if (this.dueDate != asyncTrigger.dueDate) {
            return false;
        }
        if (this.maxRetries != asyncTrigger.maxRetries) {
            return false;
        }
        if (this.retries != asyncTrigger.retries) {
            return false;
        }
        if (this.version != asyncTrigger.version) {
            return false;
        }
        if (this.definitionId != null ? !this.definitionId.equals(asyncTrigger.definitionId) : asyncTrigger.definitionId != null) {
            return false;
        }
        if (this.errorDetails != null ? !this.errorDetails.equals(asyncTrigger.errorDetails) : asyncTrigger.errorDetails != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(asyncTrigger.instanceId) : asyncTrigger.instanceId != null) {
            return false;
        }
        return !(this.nodeId != null ? !this.nodeId.equals(asyncTrigger.nodeId) : asyncTrigger.nodeId != null);
    }

    public int hashCode() {
        int result = this.nodeId != null ? this.nodeId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.definitionId != null ? this.definitionId.hashCode() : 0);
        result = 31 * result + (int)(this.dueDate ^ this.dueDate >>> 32);
        result = 31 * result + (int)(this.retries ^ this.retries >>> 32);
        result = 31 * result + (int)(this.maxRetries ^ this.maxRetries >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.errorDetails != null ? this.errorDetails.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AsyncTrigger{id=" + this.id + ", nodeId=" + this.nodeId + ", instanceId=" + this.instanceId + ", definitionId=" + this.definitionId + ", dueDate=" + this.dueDate + ", retries=" + this.retries + ", maxRetries=" + this.maxRetries + ", version=" + this.version + ", errorDetails=" + this.errorDetails + '}';
    }
}

