/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.TriggerContext;
import brainslug.flow.definition.EnumIdentifier;
import brainslug.flow.definition.Identifier;
import brainslug.flow.definition.StringIdentifier;
import brainslug.flow.execution.property.ExecutionProperties;
import brainslug.flow.instance.FlowInstanceProperties;
import brainslug.flow.instance.FlowInstanceProperty;

public class Trigger<T extends Trigger>
implements TriggerContext {
    protected Identifier definitionId;
    protected Identifier instanceId;
    protected Identifier nodeId;
    protected Boolean async = false;
    protected Boolean signaling = false;
    protected FlowInstanceProperties<?, FlowInstanceProperty<?>> properties;

    public Identifier getDefinitionId() {
        return this.definitionId;
    }

    public Identifier getInstanceId() {
        return this.instanceId;
    }

    public Identifier getNodeId() {
        return this.nodeId;
    }

    T self() {
        return (T)this;
    }

    public T definitionId(Enum id) {
        return this.definitionId((Identifier)new EnumIdentifier(id));
    }

    public T definitionId(String id) {
        return this.definitionId((Identifier)new StringIdentifier(id));
    }

    public T definitionId(Identifier definitionId) {
        this.definitionId = definitionId;
        return this.self();
    }

    public T instanceId(Identifier instanceId) {
        this.instanceId = instanceId;
        return this.self();
    }

    public T nodeId(Identifier nodeId) {
        this.nodeId = nodeId;
        return this.self();
    }

    public T async(Boolean async) {
        this.async = async;
        return this.self();
    }

    public T signaling(Boolean signaling) {
        this.signaling = signaling;
        return this.self();
    }

    public T properties(FlowInstanceProperties properties) {
        this.properties = properties;
        return this.self();
    }

    public void setProperties(FlowInstanceProperties properties) {
        this.properties = properties;
    }

    public T property(Object value) {
        this.setProperty(value.getClass().getName(), value);
        return this.self();
    }

    public T property(String key, Object value) {
        this.setProperty(key, value);
        return this.self();
    }

    public void setProperty(String key, Object value) {
        this.getProperties().with(key, value);
    }

    public <P> P getProperty(String key, Class<P> type) {
        return (P)this.getProperties().getValue(key, type);
    }

    public FlowInstanceProperties<?, FlowInstanceProperty<?>> getProperties() {
        if (this.properties == null) {
            this.properties = new ExecutionProperties();
        }
        return this.properties;
    }

    public Boolean isAsync() {
        return this.async;
    }

    public Boolean isSignaling() {
        return this.signaling;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trigger that = (Trigger)o;
        if (this.definitionId != null ? !this.definitionId.equals(that.definitionId) : that.definitionId != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(that.instanceId) : that.instanceId != null) {
            return false;
        }
        if (this.nodeId != null ? !this.nodeId.equals(that.nodeId) : that.nodeId != null) {
            return false;
        }
        if (this.async != null ? !this.async.equals(that.async) : that.async != null) {
            return false;
        }
        return !(this.signaling != null ? !this.signaling.equals(that.signaling) : that.signaling != null);
    }

    public int hashCode() {
        int result = this.definitionId != null ? this.definitionId.hashCode() : 0;
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.nodeId != null ? this.nodeId.hashCode() : 0);
        result = 31 * result + (this.async != null ? this.async.hashCode() : 0);
        result = 31 * result + (this.signaling != null ? this.signaling.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TriggerContext{definitionId=" + this.definitionId + ", instanceId=" + this.instanceId + ", nodeId=" + this.nodeId + ", async=" + this.async + ", signaling=" + this.signaling + '}';
    }
}

