/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.context;

import brainslug.flow.context.Registry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapRegistry
implements Registry {
    Map<Class<?>, Object> classesRegistry = new ConcurrentHashMap();
    Map<String, Object> nameRegistry = new ConcurrentHashMap<String, Object>();

    public <T> T getService(Class<T> serviceClass) {
        if (this.classesRegistry.get(serviceClass) == null) {
            throw new IllegalStateException("no service with class " + serviceClass + " registered");
        }
        return (T)this.classesRegistry.get(serviceClass);
    }

    public <T> void registerService(Class<T> serviceClass, T serviceInstance) {
        if (this.classesRegistry.get(serviceClass) != null) {
            throw new IllegalStateException("service class already registered " + serviceClass);
        }
        this.classesRegistry.put(serviceClass, serviceInstance);
    }

    public <T> T getService(String name, Class<T> clazz) {
        if (this.nameRegistry.get(name) == null) {
            throw new IllegalStateException("no service with name " + name + " registered");
        }
        return (T)this.nameRegistry.get(name);
    }

    public Object getService(String name) {
        return this.getService(name, Object.class);
    }

    public <T> void registerService(String name, T serviceInstance) {
        if (this.nameRegistry.get(name) != null) {
            throw new IllegalStateException("service already registered " + name);
        }
        this.nameRegistry.put(name, serviceInstance);
    }
}

