/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.listener;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.TriggerContext;
import brainslug.flow.listener.EventType;
import brainslug.flow.listener.Listener;
import brainslug.flow.listener.ListenerManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultListenerManager
implements ListenerManager {
    Logger log = LoggerFactory.getLogger(DefaultListenerManager.class);
    BrainslugContext context;
    Map<EventType, Set<Listener>> listeners = Collections.synchronizedMap(new HashMap());

    @Override
    public synchronized void notifyListeners(EventType type, TriggerContext context) {
        this.log.debug("notify listeners [{}]: {}, ", (Object)type, (Object)context);
        if (this.listeners.get((Object)type) == null) {
            this.log.debug("no listeners in context {} with event type {}", (Object)context, (Object)type);
            return;
        }
        for (Listener listener : this.listeners.get((Object)type)) {
            listener.notify(context);
        }
    }

    @Override
    public void addListener(EventType type, Listener listener) {
        this.getOrCreateListener(type).add(listener);
    }

    Set<Listener> getOrCreateListener(EventType type) {
        if (this.listeners.get((Object)type) == null) {
            this.listeners.put(type, Collections.synchronizedSet(new HashSet()));
        }
        return this.listeners.get((Object)type);
    }

    @Override
    public void removeListener(Listener listener) {
        for (Set<Listener> listeners : this.listeners.values()) {
            if (listeners.remove(listener)) break;
        }
    }

    @Override
    public void setContext(BrainslugContext context) {
        this.context = context;
    }
}

