/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.context.BrainslugContext;
import brainslug.flow.execution.async.AsyncTask;
import brainslug.flow.execution.async.AsyncTaskErrorDetails;
import brainslug.flow.execution.async.AsyncTaskExecutionResult;
import brainslug.flow.execution.async.AsyncTaskExecutor;
import brainslug.flow.node.task.RetryStrategy;
import java.util.Date;
import java.util.concurrent.Callable;

public class ExecuteTaskCallable
implements Callable<AsyncTaskExecutionResult> {
    RetryStrategy retryStrategy;
    AsyncTaskExecutor asyncTaskExecutor;
    BrainslugContext context;
    AsyncTask asyncTask;

    ExecuteTaskCallable(BrainslugContext context, AsyncTask asyncTask, AsyncTaskExecutor asyncTaskExecutor, RetryStrategy retryStrategy) {
        this.context = context;
        this.asyncTask = asyncTask;
        this.asyncTaskExecutor = asyncTaskExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public AsyncTaskExecutionResult call() {
        if (this.asyncTask.getRetries() >= this.asyncTask.getMaxRetries()) {
            throw new IllegalStateException();
        }
        AsyncTaskExecutionResult execution = this.asyncTaskExecutor.execute(this.asyncTask, this.context);
        if (execution.isFailed()) {
            this.context.getAsyncTaskStore().storeTask(this.asyncTask.incrementRetries().withDueDate(this.retryStrategy.nextRetry(this.asyncTask.getRetries(), this.getBaseDate()).getTime()).withErrorDetails(new AsyncTaskErrorDetails((Exception)execution.getException().get())));
        }
        return execution;
    }

    public Date getBaseDate() {
        return new Date();
    }
}

