/*
 * Decompiled with CFR 0.152.
 */
package brainslug.flow.execution.async;

import brainslug.flow.Identifier;
import brainslug.flow.execution.async.AsyncTaskErrorDetails;
import brainslug.util.IdUtil;
import brainslug.util.Option;

public class AsyncTask {
    Identifier id;
    Identifier taskNodeId;
    Identifier instanceId;
    Identifier definitionId;
    long createdDate = 0L;
    long dueDate = 0L;
    long retries = 0L;
    long maxRetries = 5L;
    long version = 0L;
    AsyncTaskErrorDetails errorDetails;

    public AsyncTask() {
    }

    public AsyncTask(String id, String taskNodeId, String instanceId, String definitionId, Long createdDate, Long dueDate, Long retries, Long maxRetries, Long version) {
        this.id = IdUtil.id((String)id);
        this.taskNodeId = IdUtil.id((String)taskNodeId);
        this.instanceId = IdUtil.id((String)instanceId);
        this.definitionId = IdUtil.id((String)definitionId);
        this.createdDate = createdDate;
        this.dueDate = dueDate;
        this.retries = retries;
        this.maxRetries = maxRetries;
        this.version = version;
    }

    public Identifier getTaskNodeId() {
        return this.taskNodeId;
    }

    public AsyncTask withTaskNodeId(Identifier taskNodeId) {
        this.taskNodeId = taskNodeId;
        return this;
    }

    public Identifier getInstanceId() {
        return this.instanceId;
    }

    public AsyncTask withInstanceId(Identifier instanceId) {
        this.instanceId = instanceId;
        return this;
    }

    public Identifier getDefinitionId() {
        return this.definitionId;
    }

    public AsyncTask withDefinitionId(Identifier definitionId) {
        this.definitionId = definitionId;
        return this;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public AsyncTask withDueDate(long delay) {
        this.dueDate = delay;
        return this;
    }

    public long getRetries() {
        return this.retries;
    }

    public AsyncTask incrementRetries() {
        ++this.retries;
        return this;
    }

    public long getMaxRetries() {
        return this.maxRetries;
    }

    public AsyncTask withMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public AsyncTask incrementVersion() {
        ++this.version;
        return this;
    }

    public AsyncTask withVersion(long version) {
        this.version = version;
        return this;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public AsyncTask withCreatedDate(long createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    public Option<AsyncTaskErrorDetails> getErrorDetails() {
        return Option.of((Object)this.errorDetails);
    }

    public AsyncTask withErrorDetails(AsyncTaskErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
        return this;
    }

    public Option<Identifier> getId() {
        return Option.of((Object)this.id);
    }

    public AsyncTask withId(Identifier id) {
        this.id = id;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncTask asyncTask = (AsyncTask)o;
        if (this.dueDate != asyncTask.dueDate) {
            return false;
        }
        if (this.maxRetries != asyncTask.maxRetries) {
            return false;
        }
        if (this.retries != asyncTask.retries) {
            return false;
        }
        if (this.version != asyncTask.version) {
            return false;
        }
        if (this.definitionId != null ? !this.definitionId.equals(asyncTask.definitionId) : asyncTask.definitionId != null) {
            return false;
        }
        if (this.errorDetails != null ? !this.errorDetails.equals(asyncTask.errorDetails) : asyncTask.errorDetails != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(asyncTask.instanceId) : asyncTask.instanceId != null) {
            return false;
        }
        return !(this.taskNodeId != null ? !this.taskNodeId.equals(asyncTask.taskNodeId) : asyncTask.taskNodeId != null);
    }

    public int hashCode() {
        int result = this.taskNodeId != null ? this.taskNodeId.hashCode() : 0;
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.definitionId != null ? this.definitionId.hashCode() : 0);
        result = 31 * result + (int)(this.dueDate ^ this.dueDate >>> 32);
        result = 31 * result + (int)(this.retries ^ this.retries >>> 32);
        result = 31 * result + (int)(this.maxRetries ^ this.maxRetries >>> 32);
        result = 31 * result + (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (this.errorDetails != null ? this.errorDetails.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AsyncTask{taskNodeId=" + this.taskNodeId + ", instanceId=" + this.instanceId + ", definitionId=" + this.definitionId + ", dueDate=" + this.dueDate + ", retries=" + this.retries + ", maxRetries=" + this.maxRetries + ", version=" + this.version + ", errorDetails=" + this.errorDetails + '}';
    }
}

