/*
 * Decompiled with CFR 0.152.
 */
package de.ameto.client;

import de.ameto.client.AmetoApi;
import de.ameto.client.AmetoException;
import de.ameto.client.Asset;
import de.ameto.client.JobDto;
import de.ameto.client.ProcessedAsset;
import de.ameto.client.operators.Operator;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import okhttp3.ResponseBody;
import retrofit2.Response;

public class Pipeline {
    private final AmetoApi api;
    private final String id;
    private final String name;
    private final List<Operator> steps;

    public ProcessedAsset push(Asset asset) {
        int pendingJobStatus = 0;
        JobDto job = new JobDto(asset.getId(), this.getId(), pendingJobStatus, null);
        try {
            Response getJobResponse;
            String jobId = this.submitJob(job);
            int retries = 3;
            long retryBackoff = 5000L;
            for (int attempt = 0; attempt < retries; ++attempt) {
                Response jobsResponse = this.api.getJob(jobId).execute();
                Optional<Object> currentJob = Optional.ofNullable(jobsResponse.body());
                int finishedJobStatus = 2;
                if (currentJob.isPresent() && ((JobDto)currentJob.get()).getStatus() == finishedJobStatus) break;
                try {
                    Thread.sleep(retryBackoff);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (!(getJobResponse = this.api.getJob(jobId).execute()).isSuccessful()) {
                Optional<ResponseBody> errorBody = Optional.ofNullable(getJobResponse.errorBody());
                String errorMessage = "An error occurred when fetching job information for job " + jobId;
                if (errorBody.isPresent()) {
                    errorMessage = errorBody.get().string();
                }
                throw new AmetoException(errorMessage);
            }
            Response getJobResult = this.api.getAsset(((JobDto)getJobResponse.body()).getResult()).execute();
            if (!getJobResult.isSuccessful()) {
                throw new AmetoException("Your job result could not be retrieved. It is possible that Ameto is experiencing a lot of traffic. Please try again later.");
            }
            Optional<Object> processedAssetResponseBody = Optional.ofNullable(getJobResult.body());
            if (!processedAssetResponseBody.isPresent()) {
                throw new AmetoException("Received empty response for processed asset " + jobId);
            }
            return new ProcessedAsset(jobId, ((ResponseBody)getJobResult.body()).byteStream());
        }
        catch (IOException e) {
            throw new AmetoException("Failed to process asset in pipeline", e);
        }
    }

    private String submitJob(JobDto job) throws IOException {
        Response addJobResponse = this.api.add(job).execute();
        Optional<Object> jobResponse = Optional.ofNullable(addJobResponse.body());
        return ((JobDto)jobResponse.orElseThrow(() -> new AmetoException("Job submission returned empty response"))).getId();
    }

    @ConstructorProperties(value={"api", "id", "name", "steps"})
    Pipeline(AmetoApi api, String id, String name, List<Operator> steps) {
        this.api = api;
        this.id = id;
        this.name = name;
        this.steps = steps;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Operator> getSteps() {
        return this.steps;
    }
}

