/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.js.addon.core;

import de.alpharogroup.wicket.js.addon.core.StringTextType;
import de.alpharogroup.wicket.js.addon.core.StringTextValue;
import java.text.NumberFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.wicket.util.lang.Args;

public class PercentNumberFormatTextValue
extends StringTextValue<String> {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger((String)PercentNumberFormatTextValue.class.getName());

    private static Integer checkQuietly(String name, Integer value) {
        Integer val = 50;
        try {
            val = (Integer)Args.withinRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100), (Comparable)value, (String)name);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)String.format("Given argument '%s' must have a value within [%s,%s], but was %s. Default value 50% will be set.", name, 0, 100, value));
        }
        return val;
    }

    public PercentNumberFormatTextValue(String name) {
        super(name, null);
    }

    public PercentNumberFormatTextValue(String name, Integer value) {
        super(name, NumberFormat.getPercentInstance().format((double)PercentNumberFormatTextValue.checkQuietly(name, value).intValue() / 100.0), StringTextType.STRING_INTEGER);
    }

    private Integer checkString(String value) {
        Integer val = 50;
        if (value != null && !value.isEmpty()) {
            if (value.endsWith("%")) {
                String sVal = value.substring(0, value.length() - 1);
                if (StringUtils.isNumeric((CharSequence)sVal)) {
                    val = Integer.valueOf(sVal);
                }
            } else if (StringUtils.isNumeric((CharSequence)value)) {
                val = Integer.valueOf(value);
            }
        }
        return val;
    }

    private String getPercentFormatted(Integer value) {
        Integer val = PercentNumberFormatTextValue.checkQuietly(this.getName(), value);
        return NumberFormat.getPercentInstance().format((double)val.intValue() / 100.0);
    }

    @Override
    public StringTextValue<String> setValue(Integer value) {
        String percentFormatted = this.getPercentFormatted(value);
        return this.setValue(percentFormatted);
    }

    @Override
    public StringTextValue<String> setValue(String value) {
        String val = this.getPercentFormatted(this.checkString(value));
        return super.setValue(val);
    }
}

