/**
 * Copyright (C) 2010 Asterios Raptis
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package de.alpharogroup.wicket.js.addon.enums;

import lombok.Getter;
import de.alpharogroup.wicket.js.addon.core.ValueEnum;

/**
 * An enum for a few of the effect methods in jquery.
 */
public enum EffectMethods implements ValueEnum
{
	SLIDE_TOGGLE("slideToggle"), FADE_TOGGLE("fadeToggle"), SLIDE_UP("slideUp"), SLIDE_DOWN(
		"slideDown"), FADE_OUT("fadeOut"), FADE_IN("fadeIn");

	/**
	 * The value of the easing.
	 */
	@Getter
	private final String value;

	EffectMethods(final String value)
	{
		this.value = value;
	}
}
