/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner.factories;

import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.jetty9.runner.config.ServletContextHandlerConfiguration;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.util.lang.Generics;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class WicketServletContextHandlerFactory {
    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass) {
        return WicketServletContextHandlerFactory.newWicketServletContextHandler(applicationClass, "/", PathFinder.getSrcMainJavaDir(), 300, "/*");
    }

    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass, File webapp) {
        return WicketServletContextHandlerFactory.newWicketServletContextHandler(applicationClass, "/", webapp, 300, "/*");
    }

    @Deprecated
    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass, String contextPath, File webapp, int maxInactiveInterval, String filterPath) {
        return WicketServletContextHandlerFactory.newWicketServletContextHandler(applicationClass, contextPath, webapp, maxInactiveInterval, filterPath);
    }

    @Deprecated
    public static ServletContextHandler newServletContextHandler(ServletContextHandlerConfiguration configuration) {
        return WicketServletContextHandlerFactory.newWicketServletContextHandler(configuration);
    }

    public static ServletContextHandler newWicketServletContextHandler(Class<? extends Application> applicationClass, String contextPath, File webapp, int maxInactiveInterval, String filterPath) {
        HashMap initParameters = Generics.newHashMap();
        initParameters.put("filterMappingUrlPattern", filterPath);
        return WicketServletContextHandlerFactory.newWicketServletContextHandler(ServletContextHandlerConfiguration.builder().applicationClass(applicationClass).contextPath(contextPath).webapp(webapp).maxInactiveInterval(maxInactiveInterval).initParameter("filterMappingUrlPattern", filterPath).filterPath(filterPath).build());
    }

    public static ServletContextHandler newWicketServletContextHandler(ServletContextHandlerConfiguration configuration) {
        ServletContextHandler context = configuration.getParent() != null ? new ServletContextHandler(configuration.getParent(), configuration.getContextPath()) : new ServletContextHandler(1);
        context.setContextPath(configuration.getContextPath());
        context.setResourceBase(configuration.getWebapp().getAbsolutePath());
        FilterHolder filter = new FilterHolder(WicketFilter.class);
        filter.setInitParameter("applicationClassName", configuration.getApplicationClass().getName());
        for (Map.Entry initParameter : configuration.getInitParameters().entrySet()) {
            filter.setInitParameter((String)initParameter.getKey(), (String)initParameter.getValue());
        }
        context.addFilter(filter, configuration.getFilterPath(), EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR));
        context.addServlet(DefaultServlet.class, configuration.getFilterPath());
        context.getSessionHandler().setMaxInactiveInterval(configuration.getMaxInactiveInterval());
        return context;
    }
}

