/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner;

import de.alpharogroup.file.delete.DeleteFileExtensions;
import de.alpharogroup.jetty9.runner.Jetty9Runner;
import de.alpharogroup.jetty9.runner.config.FilterHolderConfiguration;
import de.alpharogroup.jetty9.runner.config.Jetty9RunConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletContextHandlerConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletHolderConfiguration;
import de.alpharogroup.jetty9.runner.config.StartConfig;
import de.alpharogroup.jetty9.runner.factories.DeploymentManagerFactory;
import de.alpharogroup.jetty9.runner.factories.ServletContextHandlerFactory;
import de.alpharogroup.jetty9.runner.factories.WicketServletContextHandlerFactory;
import de.alpharogroup.log.LoggerExtensions;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WicketFilter;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class WicketJetty9Runner {
    public static final String WICKET_CONFIGURATION_KEY = "wicket.configuration";

    public static void run(Class<? extends Application> applicationClass, File webapp) {
        WicketJetty9Runner.run(applicationClass, webapp, 8080, 8443, "wicket");
    }

    public static void run(Class<? extends Application> applicationClass, File webapp, int httpPort, int httpsPort, String keyStorePassword) {
        Jetty9Runner.runWithNewServer((ServletContextHandler)WicketServletContextHandlerFactory.newServletContextHandler(applicationClass, webapp), (int)httpPort, (int)httpsPort);
    }

    public static void run(StartConfig startConfig) {
        WicketJetty9Runner.run(startConfig, new Server());
    }

    public static void run(StartConfig startConfig, Server server) {
        System.setProperty(WICKET_CONFIGURATION_KEY, startConfig.getRuntimeConfigurationType());
        if (startConfig.getLogFile().exists()) {
            try {
                DeleteFileExtensions.delete((File)startConfig.getLogFile());
            }
            catch (IOException e) {
                Logger.getRootLogger().error((Object)"logfile could not deleted.", (Throwable)e);
            }
        }
        LoggerExtensions.addFileAppender((Logger)Logger.getRootLogger(), (FileAppender)LoggerExtensions.newFileAppender((String)startConfig.getAbsolutePathFromLogfile()));
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler servletContextHandler = ServletContextHandlerFactory.getNewServletContextHandler((ServletContextHandlerConfiguration)ServletContextHandlerConfiguration.builder().parent((HandlerContainer)contexts).filterHolderConfiguration(FilterHolderConfiguration.builder().filterClass(WicketFilter.class).filterPath(startConfig.getFilterPath()).initParameter("filterMappingUrlPattern", startConfig.getFilterPath()).initParameter("applicationClassName", startConfig.getApplicationName()).build()).servletHolderConfiguration(ServletHolderConfiguration.builder().servletClass(DefaultServlet.class).pathSpec(startConfig.getFilterPath()).build()).contextPath(startConfig.getContextPath()).webapp(startConfig.getWebapp()).maxInactiveInterval(startConfig.getSessionTimeout()).filterPath(startConfig.getFilterPath()).build());
        DeploymentManager deployer = DeploymentManagerFactory.newDeploymentManager((ContextHandlerCollection)contexts, (String)startConfig.getWebapp().getAbsolutePath(), null);
        Jetty9RunConfiguration configuration = Jetty9Runner.newJetty9RunConfiguration((ServletContextHandler)servletContextHandler, (ContextHandlerCollection)contexts, (DeploymentManager)deployer, (StartConfig)startConfig);
        Jetty9Runner.runServletContextHandler((Server)server, (Jetty9RunConfiguration)configuration);
    }
}

