/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner.factories;

import de.alpharogroup.file.search.PathFinder;
import de.alpharogroup.jetty9.runner.config.FilterHolderConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletContextHandlerConfiguration;
import de.alpharogroup.jetty9.runner.config.ServletHolderConfiguration;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.http.WicketFilter;
import org.apache.wicket.util.lang.Generics;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class ServletContextHandlerFactory {
    public static ServletContextHandler getNewServletContextHandler(ServletContextHandlerConfiguration configuration) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath(configuration.getContextPath());
        context.setResourceBase(configuration.getWebapp().getAbsolutePath());
        context.getSessionHandler().getSessionManager().setMaxInactiveInterval(configuration.getMaxInactiveInterval());
        ServletContextHandlerFactory.initializeFilterHolder(configuration, context);
        ServletContextHandlerFactory.initializeServletHolder(configuration, context);
        for (Map.Entry<String, String> initParameter : configuration.getInitParameters().entrySet()) {
            context.setInitParameter(initParameter.getKey(), initParameter.getValue());
        }
        return context;
    }

    private static void initializeFilterHolder(ServletContextHandlerConfiguration configuration, ServletContextHandler context) {
        List<FilterHolderConfiguration> filterHolderConfigurations = configuration.getFilterHolderConfigurations();
        if (CollectionUtils.isNotEmpty(filterHolderConfigurations)) {
            for (FilterHolderConfiguration filterHolderConfiguration : filterHolderConfigurations) {
                FilterHolder filter = new FilterHolder(filterHolderConfiguration.getFilterClass());
                if (StringUtils.isNotEmpty((String)filterHolderConfiguration.getName())) {
                    filter.setName(filterHolderConfiguration.getName());
                }
                if (MapUtils.isNotEmpty(filterHolderConfiguration.getInitParameters())) {
                    for (Map.Entry<String, String> initParameter : filterHolderConfiguration.getInitParameters().entrySet()) {
                        filter.setInitParameter(initParameter.getKey(), initParameter.getValue());
                    }
                }
                if (!StringUtils.isNotEmpty((String)filterHolderConfiguration.getFilterPath())) continue;
                context.addFilter(filter, filterHolderConfiguration.getFilterPath(), EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR));
            }
        }
    }

    private static void initializeServletHolder(ServletContextHandlerConfiguration configuration, ServletContextHandler context) {
        List<ServletHolderConfiguration> servletHolderConfigurations = configuration.getServletHolderConfigurations();
        if (CollectionUtils.isNotEmpty(servletHolderConfigurations)) {
            for (ServletHolderConfiguration servletHolderConfiguration : servletHolderConfigurations) {
                ServletHolder servletHolder = new ServletHolder(servletHolderConfiguration.getServletClass());
                String servletName = servletHolderConfiguration.getName();
                if (StringUtils.isNotEmpty((String)servletName)) {
                    servletHolder.setName(servletHolderConfiguration.getName());
                }
                if (MapUtils.isNotEmpty(servletHolderConfiguration.getInitParameters())) {
                    for (Map.Entry<String, String> initParameter : servletHolderConfiguration.getInitParameters().entrySet()) {
                        servletHolder.setInitParameter(initParameter.getKey(), initParameter.getValue());
                    }
                }
                if (!StringUtils.isNotEmpty((String)servletHolderConfiguration.getPathSpec())) continue;
                context.addServlet(servletHolder, servletHolderConfiguration.getPathSpec());
            }
        }
    }

    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass) {
        return ServletContextHandlerFactory.newServletContextHandler(applicationClass, "/", PathFinder.getSrcMainJavaDir(), 300, "/*");
    }

    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass, File webapp) {
        return ServletContextHandlerFactory.newServletContextHandler(applicationClass, "/", webapp, 300, "/*");
    }

    public static ServletContextHandler newServletContextHandler(Class<? extends Application> applicationClass, String contextPath, File webapp, int maxInactiveInterval, String filterPath) {
        HashMap initParameters = Generics.newHashMap();
        initParameters.put("filterMappingUrlPattern", filterPath);
        return ServletContextHandlerFactory.newServletContextHandler(ServletContextHandlerConfiguration.builder().applicationClass(applicationClass).contextPath(contextPath).webapp(webapp).maxInactiveInterval(maxInactiveInterval).initParameter("filterMappingUrlPattern", filterPath).filterPath(filterPath).build());
    }

    public static ServletContextHandler newServletContextHandler(ServletContextHandlerConfiguration configuration) {
        ServletContextHandler context = configuration.getParent() != null ? new ServletContextHandler(configuration.getParent(), configuration.getContextPath()) : new ServletContextHandler(1);
        context.setContextPath(configuration.getContextPath());
        context.setResourceBase(configuration.getWebapp().getAbsolutePath());
        FilterHolder filter = new FilterHolder(WicketFilter.class);
        filter.setInitParameter("applicationClassName", configuration.getApplicationClass().getName());
        for (Map.Entry<String, String> initParameter : configuration.getInitParameters().entrySet()) {
            filter.setInitParameter(initParameter.getKey(), initParameter.getValue());
        }
        context.addFilter(filter, configuration.getFilterPath(), EnumSet.of(DispatcherType.REQUEST, DispatcherType.ERROR));
        context.addServlet(DefaultServlet.class, configuration.getFilterPath());
        context.getSessionHandler().getSessionManager().setMaxInactiveInterval(configuration.getMaxInactiveInterval());
        return context;
    }
}

