/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.jetty9.runner.factories;

import org.eclipse.jetty.deploy.AppProvider;
import org.eclipse.jetty.deploy.ConfigurationManager;
import org.eclipse.jetty.deploy.DeploymentManager;
import org.eclipse.jetty.deploy.PropertiesConfigurationManager;
import org.eclipse.jetty.deploy.providers.WebAppProvider;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

public class DeploymentManagerFactory {
    public static DeploymentManager newDeploymentManager(ContextHandlerCollection contexts, String monitoredDirName, String defaultsDescriptor) {
        DeploymentManager deployer = new DeploymentManager();
        deployer.setContexts(contexts);
        deployer.setContextAttribute("org.eclipse.jetty.server.webapp.ContainerIncludeJarPattern", (Object)".*/servlet-api-[^/]*\\.jar$");
        WebAppProvider webAppProvider = new WebAppProvider();
        webAppProvider.setMonitoredDirName(monitoredDirName);
        if (defaultsDescriptor != null) {
            webAppProvider.setDefaultsDescriptor(defaultsDescriptor);
        }
        webAppProvider.setScanInterval(1);
        webAppProvider.setExtractWars(true);
        webAppProvider.setConfigurationManager((ConfigurationManager)new PropertiesConfigurationManager());
        deployer.addAppProvider((AppProvider)webAppProvider);
        return deployer;
    }
}

