/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.radio;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.radio.RadioGroupModelBean;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormChoiceComponentUpdatingBehavior;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.Radio;
import org.apache.wicket.markup.html.form.RadioGroup;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;

public abstract class RadioGroupPanel<T>
extends BasePanel<RadioGroupModelBean<T>> {
    private static final long serialVersionUID = 1L;
    private RadioGroup<T> group;
    Form<?> form;

    public RadioGroupPanel(String id, IModel<RadioGroupModelBean<T>> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.group = this.newRadioGroup(this.newRadioName(), (IModel<T>)new PropertyModel(model, "selected"));
        componentArray2[0] = this.group;
        this.form.add(componentArray2);
        this.group.add(new Component[]{this.newRadioListView("choice", model)});
    }

    protected Form<RadioGroupModelBean<T>> newForm(String id, IModel<RadioGroupModelBean<T>> model) {
        Form<RadioGroupModelBean<T>> form = ComponentFactory.newForm(id, model);
        return form;
    }

    protected Label newLabel(String id, String forId, IModel<T> model) {
        return ComponentFactory.newLabel(id, forId, model);
    }

    protected RadioGroup<T> newRadioGroup(String id, IModel<T> model) {
        RadioGroup<T> group = ComponentFactory.newRadioGroup(id, model);
        group.add(new Behavior[]{new AjaxFormChoiceComponentUpdatingBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                RadioGroupPanel.this.onUpdate(target);
            }
        }});
        return group;
    }

    protected ListView<T> newRadioListView(String id, IModel<RadioGroupModelBean<T>> model) {
        ListView radioListView = new ListView<T>("choice", ((RadioGroupModelBean)model.getObject()).getRadios()){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<T> item) {
                Radio radio = new Radio("radio", item.getModel(), RadioGroupPanel.this.group);
                radio.setOutputMarkupId(true);
                item.add(new Component[]{radio});
                item.add(new Component[]{RadioGroupPanel.this.newLabel("label", radio.getMarkupId(), item.getModel())});
            }
        };
        radioListView.setOutputMarkupId(true);
        return radioListView;
    }

    protected String newRadioName() {
        return "group";
    }

    protected void onUpdate(AjaxRequestTarget target) {
    }

    public RadioGroup<T> getGroup() {
        return this.group;
    }
}

