/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.menu.suckerfish;

import de.alpharogroup.wicket.components.factory.ComponentFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class MenuItem
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final AbstractLink link;
    private final Label label;
    private final List<MenuItem> children = new ArrayList<MenuItem>();

    public MenuItem(AbstractLink link, IModel<String> labelModel) {
        if (link != null && !link.getId().equals("linkid")) {
            throw new IllegalArgumentException("The id have to be SuckerfishMenuPanel.LINK_ID");
        }
        this.link = link;
        Component[] componentArray = new Component[1];
        this.label = this.newLabel("linktext", labelModel);
        componentArray[0] = this.label;
        this.link.add(componentArray);
    }

    public MenuItem(AbstractLink link, String label) {
        this(link, (IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public MenuItem(IModel<String> labelModel) {
        this.link = null;
        this.label = this.newLabel("linktext", labelModel);
    }

    public MenuItem(String label) {
        this((IModel<String>)Model.of((Serializable)((Object)label)));
    }

    public MenuItem addMenu(MenuItem menu) {
        this.children.add(menu);
        return this;
    }

    protected Label newLabel(String id, IModel<String> model) {
        return ComponentFactory.newLabel(id, model);
    }

    public MenuItem setMenuItems(List<MenuItem> menuItems) {
        this.children.clear();
        this.children.addAll(menuItems);
        return this;
    }

    public AbstractLink getLink() {
        return this.link;
    }

    public Label getLabel() {
        return this.label;
    }

    public List<MenuItem> getChildren() {
        return this.children;
    }
}

