/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.form.dropdown;

import de.alpharogroup.wicket.components.form.dropdown.OptGroup;
import java.util.List;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.AppendingStringBuffer;
import org.apache.wicket.util.string.Strings;

public abstract class OptGroupDropDownChoice<T extends OptGroup>
extends DropDownChoice<T> {
    private static final String CLOSE_OPTGROUP_TAG = "\n</optgroup>";
    private static final long serialVersionUID = 1L;
    private T last;

    public OptGroupDropDownChoice(String id) {
        super(id);
    }

    public OptGroupDropDownChoice(String id, IModel<? extends List<? extends T>> choices) {
        super(id, choices);
    }

    public OptGroupDropDownChoice(String id, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    public OptGroupDropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices) {
        super(id, model, choices);
    }

    public OptGroupDropDownChoice(String id, IModel<T> model, IModel<? extends List<? extends T>> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public OptGroupDropDownChoice(String id, IModel<T> model, List<? extends T> choices) {
        super(id, model, choices);
    }

    public OptGroupDropDownChoice(String id, IModel<T> model, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, model, choices, renderer);
    }

    public OptGroupDropDownChoice(String id, List<? extends T> choices) {
        super(id, choices);
    }

    public OptGroupDropDownChoice(String id, List<? extends T> choices, IChoiceRenderer<? super T> renderer) {
        super(id, choices, renderer);
    }

    private void appendOptGroupLabel(AppendingStringBuffer buffer, T optGroup) {
        buffer.append("\n<optgroup label='").append((Object)Strings.escapeMarkup((CharSequence)this.getOptGroupLabel(optGroup))).append("'>");
    }

    protected void appendOptionHtml(AppendingStringBuffer buffer, T choice, int index, String selected) {
        T currentOptGroup = choice;
        if (this.isNewGroup((OptGroup)currentOptGroup)) {
            if (!this.isFirst(index)) {
                buffer.append(CLOSE_OPTGROUP_TAG);
            }
            this.appendOptGroupLabel(buffer, currentOptGroup);
        }
        super.appendOptionHtml(buffer, choice, index, selected);
        if (this.isLast(index)) {
            buffer.append(CLOSE_OPTGROUP_TAG);
        }
        this.last = currentOptGroup;
    }

    protected abstract String getOptGroupLabel(T var1);

    private boolean isFirst(int index) {
        return index == 0;
    }

    private boolean isLast(int index) {
        return index - 1 == this.getChoices().size();
    }

    private boolean isNewGroup(OptGroup currentOptGroup) {
        return this.last == null || !currentOptGroup.getLabel().equals(this.last.getLabel());
    }

    protected void onDetach() {
        super.onDetach();
        this.last = null;
    }
}

