/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.deregistration;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.resourcebundle.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.behaviors.JQueryJsAppenderBehavior;
import de.alpharogroup.wicket.components.deregistration.DeregistrationModelBean;
import de.alpharogroup.wicket.components.factory.ComponentFactory;
import de.alpharogroup.wicket.components.i18n.content.ContentModelBean;
import de.alpharogroup.wicket.components.i18n.content.ContentPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public abstract class DeregistrationPanel
extends BasePanel<DeregistrationModelBean> {
    private static final long serialVersionUID = 1L;
    private Label buttonLabel;
    private Button submitButton;
    private Component motivation;
    private Component contentPanel;
    private Form<?> form;

    public DeregistrationPanel(String id, IModel<DeregistrationModelBean> model) {
        super(id, model);
    }

    public abstract String getDomainName();

    protected Button newButton(String id) {
        return new Button(id){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                DeregistrationPanel.this.onDeregistration(null);
            }
        };
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue) {
        return ComponentFactory.newLabel(id, ResourceModelFactory.newResourceModel((String)resourceKey, (Component)this, (String)defaultValue));
    }

    protected Component newContentPanel(String id) {
        ContentPanel contentPanel = new ContentPanel("contentPanel", (IModel<ContentModelBean>)Model.of((Serializable)ContentModelBean.builder().headerResourceKey(ResourceBundleKey.builder().key("sem.main.info.frame.deregistration.user.label").parameters(ListExtensions.toObjectArray((Object[])new String[]{this.getDomainName()})).build()).contentResourceKey(ResourceBundleKey.builder().key("sem.main.info.frame.deregistration.user.label").parameters(ListExtensions.toObjectArray((Object[])new String[]{this.getDomainName()})).build()).build()));
        contentPanel.getHeader().add(new Behavior[]{new JQueryJsAppenderBehavior((CharSequence)"wrap", (CharSequence)"<h1></h1>")});
        contentPanel.getContent().add(new Behavior[]{new JQueryJsAppenderBehavior((CharSequence)"wrap", (CharSequence)"<p class=\"lead\"></p>")});
        return contentPanel;
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        return ComponentFactory.newForm(id, model);
    }

    protected Label newLabel(String id, ResourceBundleKey resourceKey) {
        return ComponentFactory.newLabel(id, resourceKey, (Component)this);
    }

    protected LabeledTextAreaPanel<String, DeregistrationModelBean> newMotivation(String id, IModel<DeregistrationModelBean> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("sem.main.feedback.deregistration.user.label").defaultValue("Please confirm the deregistration").parameters(ListExtensions.toObjectArray((Object[])new String[]{this.getDomainName()})).build(), (Component)this);
        final IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.deregistration.motivation.label", (Component)this, (String)"Enter here your deregistration motivation.");
        LabeledTextAreaPanel<String, DeregistrationModelBean> description = new LabeledTextAreaPanel<String, DeregistrationModelBean>(id, model, labelModel){
            private static final long serialVersionUID = 1L;

            @Override
            protected TextArea<String> newTextArea(String id, IModel<DeregistrationModelBean> model) {
                TextArea textArea = super.newTextArea(id, model);
                if (placeholderModel != null) {
                    textArea.add(new Behavior[]{new AttributeAppender("placeholder", placeholderModel)});
                }
                return textArea;
            }
        };
        return description;
    }

    public void onBeforeRender() {
        this.contentPanel = this.newContentPanel("contentPanel");
        this.addOrReplace(new Component[]{this.contentPanel});
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", this.getModel());
        componentArray[0] = this.form;
        this.addOrReplace(componentArray);
        this.motivation = this.newMotivation("motivation", (IModel<DeregistrationModelBean>)this.getModel());
        this.form.addOrReplace(new Component[]{this.motivation});
        this.submitButton = this.newButton("submitButton");
        Component[] componentArray2 = new Component[1];
        this.buttonLabel = this.newButtonLabel("buttonLabel", "sem.main.global.deregistration.user.label", "Deregister");
        componentArray2[0] = this.buttonLabel;
        this.submitButton.addOrReplace(componentArray2);
        this.form.addOrReplace(new Component[]{this.submitButton});
        super.onBeforeRender();
    }

    public abstract void onDeregistration(AjaxRequestTarget var1);

    public Label getButtonLabel() {
        return this.buttonLabel;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    public Component getMotivation() {
        return this.motivation;
    }

    public Component getContentPanel() {
        return this.contentPanel;
    }

    public Form<?> getForm() {
        return this.form;
    }
}

