/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import java.io.File;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public final class Zip4jUtils {
    public static void extract(ZipFile zipFile4j, File destination, String password) throws ZipException {
        if (zipFile4j.isEncrypted()) {
            zipFile4j.setPassword(password);
        }
        zipFile4j.extractAll(destination.getAbsolutePath());
    }

    public static void zipFiles(ZipFile zipFile4j, File ... toAdd) throws ZipException {
        Zip4jUtils.zipFiles(zipFile4j, 8, 5, toAdd);
    }

    public static void zipFiles(ZipFile zipFile4j, int compressionMethod, int compressionLevel, File ... toAdd) throws ZipException {
        ZipParameters parameters = new ZipParameters();
        parameters.setCompressionMethod(compressionMethod);
        parameters.setCompressionLevel(compressionLevel);
        Zip4jUtils.zipFiles(zipFile4j, parameters, toAdd);
    }

    public static void zipFiles(ZipFile zipFile4j, ZipParameters parameters, File ... toAdd) throws ZipException {
        for (File element : toAdd) {
            zipFile4j.addFile(element, parameters);
        }
    }
}

