/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.csv;

import de.alpharogroup.file.csv.CsvBean;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class CsvToSqlUtils {
    public static String extractSqlColumns(String[] headers) {
        StringBuffer sqlColumns = new StringBuffer();
        sqlColumns.append("");
        for (int i = 0; i < headers.length; ++i) {
            sqlColumns.append(headers[i]);
            if (i < headers.length - 1) {
                sqlColumns.append(", ");
                continue;
            }
            sqlColumns.append("");
        }
        return sqlColumns.toString();
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, CsvBean csvBean) {
        return CsvToSqlUtils.getCsvFileAsSqlInsertScript(tableName, csvBean, true, true);
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, CsvBean csvBean, boolean withHeader, boolean withEndSemicolon) {
        String[] columnTypesEdit;
        StringBuffer sb = new StringBuffer();
        if (withHeader) {
            String sqlColumns = CsvToSqlUtils.extractSqlColumns(csvBean.getHeaders());
            sb.append("INSERT INTO " + tableName + " ( " + sqlColumns + ") VALUES \n");
        }
        if ((columnTypesEdit = csvBean.getColumnTypesEdit()) != null) {
            StringBuffer sqlData = CsvToSqlUtils.getSqlData(csvBean.getHeaders(), csvBean.getColumnTypes(), columnTypesEdit, csvBean.getLineOrder(), csvBean.getLines(), withEndSemicolon);
            sb.append(sqlData.toString());
        } else {
            StringBuffer sqlData = CsvToSqlUtils.getSqlData(csvBean.getHeaders(), csvBean.getColumnTypes(), null, null, csvBean.getLines(), true);
            sb.append(sqlData.toString());
        }
        return sb.toString();
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, String[] headers, String[] columnTypes, List<String[]> lines) {
        return CsvToSqlUtils.getCsvFileAsSqlInsertScript(tableName, new CsvBean(headers, columnTypes, lines));
    }

    public static String getCsvFileAsSqlInsertScript(String tableName, String[] headers, String[] columnTypes, String[] columnTypesEdit, List<String[]> lines) {
        return CsvToSqlUtils.getCsvFileAsSqlInsertScript(tableName, new CsvBean(headers, columnTypes, columnTypesEdit, lines));
    }

    public static String[] getDataFromLine(String line, String seperator) {
        String[] splittedLine = line.split(seperator);
        return splittedLine;
    }

    public static StringBuffer getSqlData(String[] columns, String[] columnTypes, String[] columnTypesEdit, Map<Integer, Integer> lineOrder, List<String[]> lines, boolean withEndSemicolon) {
        StringBuffer sb = new StringBuffer();
        int autoincrement = 0;
        Iterator<String[]> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String[] line;
            if (lineOrder != null) {
                String[] trueLine = iterator.next();
                String[] newLine = new String[columnTypes.length];
                for (Integer index : lineOrder.keySet()) {
                    newLine[lineOrder.get((Object)index).intValue()] = trueLine[index];
                }
                line = newLine;
            } else {
                line = iterator.next();
            }
            sb.append("(");
            for (int i = 0; i < line.length; ++i) {
                String lineItem = line[i];
                String columTypeEdit = columnTypesEdit[i];
                if (columTypeEdit != null) {
                    String[] editTypeData = columTypeEdit.split(",");
                    String editType = editTypeData[0];
                    if (editType.equals("edit")) {
                        lineItem = lineItem.replace(editTypeData[1], editTypeData[2]);
                        if (2 < editTypeData.length) {
                            Boolean lc = new Boolean(editTypeData[3]);
                            if (lc.booleanValue()) {
                                String tlc = lineItem.toLowerCase();
                                sb.append("\"" + tlc + "\"");
                            } else {
                                sb.append("\"" + lineItem + "\"");
                            }
                        } else {
                            sb.append("\"" + lineItem + "\"");
                        }
                    } else if (editType.equals("autoincrement")) {
                        int startCount = Integer.parseInt(editTypeData[1]);
                        if (i == 0 && autoincrement == 0) {
                            autoincrement = startCount;
                        }
                        sb.append(autoincrement);
                        ++autoincrement;
                    } else if (editType.equals("constant")) {
                        String type = editTypeData[1];
                        if (type.equals("text")) {
                            sb.append("\"" + editTypeData[2] + "\"");
                        } else {
                            sb.append(editTypeData[2]);
                        }
                    }
                } else if (lineItem != null) {
                    if (columnTypes[i].endsWith("text")) {
                        sb.append("\"" + lineItem + "\"");
                    } else {
                        sb.append(lineItem);
                    }
                } else {
                    sb.append(lineItem);
                }
                if (i >= columns.length - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
            if (iterator.hasNext()) {
                sb.append(",\n");
                continue;
            }
            if (withEndSemicolon) {
                sb.append(";\n");
                continue;
            }
            sb.append(",\n");
        }
        return sb;
    }

    private CsvToSqlUtils() {
    }
}

