/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.compare;

import de.alpharogroup.file.FileUtils;
import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumUtils;
import de.alpharogroup.file.compare.FileCompareResultBean;
import de.alpharogroup.file.compare.FileContentResultBean;
import de.alpharogroup.file.compare.interfaces.IFileCompareResultBean;
import de.alpharogroup.file.compare.interfaces.IFileContentResultBean;
import de.alpharogroup.file.search.FileSearchUtils;
import de.alpharogroup.io.StreamUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

public final class CompareFileUtils {
    public static void compare(IFileCompareResultBean fileCompareResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        File source = fileCompareResultBean.getSourceFile();
        File compare = fileCompareResultBean.getFileToCompare();
        if (!ignoreAbsolutePathEquality) {
            String sourceAbsolutePath = source.getAbsolutePath();
            String compareAbsolutePath = compare.getAbsolutePath();
            boolean absolutePathEquality = sourceAbsolutePath.equals(compareAbsolutePath);
            fileCompareResultBean.setAbsolutePathEquality(absolutePathEquality);
        } else {
            fileCompareResultBean.setAbsolutePathEquality(true);
        }
        if (!ignoreExtensionEquality) {
            String sourceFileExtension = FileUtils.getFilenameSuffix(source);
            String compareFileExtension = FileUtils.getFilenameSuffix(compare);
            boolean extensionEquality = compareFileExtension.equalsIgnoreCase(sourceFileExtension);
            fileCompareResultBean.setFileExtensionEquality(extensionEquality);
        } else {
            fileCompareResultBean.setFileExtensionEquality(true);
        }
        if (!ignoreLengthEquality) {
            boolean length = source.length() == compare.length();
            fileCompareResultBean.setLengthEquality(length);
        } else {
            fileCompareResultBean.setLengthEquality(true);
        }
        if (!ignoreLastModified) {
            boolean lastModified = source.lastModified() == compare.lastModified();
            fileCompareResultBean.setLastModifiedEquality(lastModified);
        } else {
            fileCompareResultBean.setLastModifiedEquality(true);
        }
        if (!ignoreNameEquality) {
            String sourceFilename = FileUtils.getFilenameWithoutExtension(source);
            String compareFilename = FileUtils.getFilenameWithoutExtension(compare);
            boolean nameEquality = compareFilename.equalsIgnoreCase(sourceFilename);
            fileCompareResultBean.setNameEquality(nameEquality);
        } else {
            fileCompareResultBean.setNameEquality(true);
        }
    }

    public static void compare(IFileContentResultBean fileContentResultBean, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        CompareFileUtils.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        File source = fileContentResultBean.getSourceFile();
        File compare = fileContentResultBean.getFileToCompare();
        if (!ignoreContentEquality) {
            try {
                String sourceChecksum = ChecksumUtils.getChecksum(source, Algorithm.SHA_512.getAlgorithm());
                String compareChecksum = ChecksumUtils.getChecksum(compare, Algorithm.SHA_512.getAlgorithm());
                boolean contentEquality = sourceChecksum.equals(compareChecksum);
                fileContentResultBean.setContentEquality(contentEquality);
            }
            catch (NoSuchAlgorithmException e) {
                boolean contentEquality = ChecksumUtils.getCheckSumCRC32(source) == ChecksumUtils.getCheckSumCRC32(compare);
                fileContentResultBean.setContentEquality(contentEquality);
            }
        } else {
            fileContentResultBean.setContentEquality(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IFileContentResultBean compareFileContentByBytes(File sourceFile, File fileToCompare) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileUtils.completeCompare(fileContentResultBean);
        boolean simpleEquality = CompareFileUtils.validateEquality(fileContentResultBean);
        boolean contentEquality = true;
        if (simpleEquality) {
            InputStream sourceReader = null;
            InputStream compareReader = null;
            try {
                sourceReader = StreamUtils.getInputStream((File)sourceFile);
                compareReader = StreamUtils.getInputStream((File)fileToCompare);
                byte[] source = StreamUtils.getByteArray((InputStream)sourceReader);
                byte[] compare = StreamUtils.getByteArray((InputStream)compareReader);
                int i = 0;
                while (0 < source.length) {
                    if (source[i] != compare[i]) {
                        contentEquality = false;
                        break;
                    }
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                contentEquality = false;
            }
            catch (IOException e) {
                contentEquality = false;
            }
            finally {
                StreamUtils.closeInputStream((InputStream)sourceReader);
                StreamUtils.closeInputStream((InputStream)compareReader);
            }
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static IFileContentResultBean compareFileContentByLines(File sourceFile, File fileToCompare) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileUtils.completeCompare(fileContentResultBean);
        boolean simpleEquality = CompareFileUtils.validateEquality(fileContentResultBean);
        boolean contentEquality = true;
        if (simpleEquality) {
            BufferedReader sourceReader = null;
            BufferedReader compareReader = null;
            try {
                String sourceLine;
                sourceReader = (BufferedReader)StreamUtils.getReader((File)sourceFile);
                compareReader = (BufferedReader)StreamUtils.getReader((File)fileToCompare);
                while ((sourceLine = sourceReader.readLine()) != null) {
                    String compareLine = compareReader.readLine();
                    if (compareLine != null && sourceLine.equals(compareLine)) continue;
                    contentEquality = false;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                contentEquality = false;
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
            catch (IOException e2) {
                contentEquality = false;
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeReader((Reader)sourceReader);
                        StreamUtils.closeReader(compareReader);
                        throw throwable;
                    }
                }
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
            StreamUtils.closeReader((Reader)sourceReader);
            StreamUtils.closeReader((Reader)compareReader);
        }
        fileContentResultBean.setContentEquality(contentEquality);
        return fileContentResultBean;
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare) {
        return CompareFileUtils.compareFiles(sourceFile, fileToCompare, true, false, false, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean compareFiles(File source, File compare, boolean content) {
        boolean equal = true;
        boolean sameFilename = false;
        if (!source.exists()) {
            return !compare.exists() && (sameFilename = source.getName().equals(compare.getName()));
        }
        if (!compare.exists()) {
            return false;
        }
        if (source.length() != compare.length()) {
            return false;
        }
        if (content) {
            BufferedReader sourceReader = null;
            BufferedReader compareReader = null;
            try {
                String sourceLine;
                sourceReader = (BufferedReader)StreamUtils.getReader((File)source);
                compareReader = (BufferedReader)StreamUtils.getReader((File)compare);
                while ((sourceLine = sourceReader.readLine()) != null) {
                    String compareLine = compareReader.readLine();
                    if (compareLine != null && sourceLine.equals(compareLine)) continue;
                    equal = false;
                    break;
                }
            }
            catch (FileNotFoundException e) {
                equal = false;
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
            catch (IOException e2) {
                equal = false;
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeReader((Reader)sourceReader);
                        StreamUtils.closeReader(compareReader);
                        throw throwable;
                    }
                }
                StreamUtils.closeReader((Reader)sourceReader);
                StreamUtils.closeReader((Reader)compareReader);
            }
            StreamUtils.closeReader((Reader)sourceReader);
            StreamUtils.closeReader((Reader)compareReader);
        }
        return equal;
    }

    public static IFileCompareResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        FileCompareResultBean fileCompareResultBean = new FileCompareResultBean(sourceFile, fileToCompare);
        CompareFileUtils.compare(fileCompareResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality);
        return fileCompareResultBean;
    }

    public static IFileContentResultBean compareFiles(File sourceFile, File fileToCompare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        FileContentResultBean fileContentResultBean = new FileContentResultBean(sourceFile, fileToCompare);
        CompareFileUtils.compare(fileContentResultBean, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality);
        return fileContentResultBean;
    }

    public static void completeCompare(IFileCompareResultBean fileCompareResultBean) {
        CompareFileUtils.compare(fileCompareResultBean, false, false, false, false, false);
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch) {
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (File file : allFiles) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.simpleCompareFiles(toCompare, file))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.simpleCompareFiles(toCompare, file))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileCompareResultBean> findEqualFiles(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileCompareResultBean> equalFiles = new ArrayList<IFileCompareResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileCompareResultBean compareResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(compareResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality))) || equalFiles.contains(compareResultBean)) continue;
                equalFiles.add(compareResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File dirToSearch, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        List<File> allFiles = FileSearchUtils.findFilesRecursive(dirToSearch, "*");
        for (int i = 0; i < allFiles.size(); ++i) {
            File toCompare = allFiles.get(i);
            for (int j = 0; j < allFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static List<IFileContentResultBean> findEqualFilesWithSameContent(File source, File compare, boolean ignoreAbsolutePathEquality, boolean ignoreExtensionEquality, boolean ignoreLengthEquality, boolean ignoreLastModified, boolean ignoreNameEquality, boolean ignoreContentEquality) {
        List<File> allSourceFiles = FileSearchUtils.findFilesRecursive(source, "*");
        List<File> allCompareFiles = FileSearchUtils.findFilesRecursive(compare, "*");
        ArrayList<IFileContentResultBean> equalFiles = new ArrayList<IFileContentResultBean>();
        for (int i = 0; i < allSourceFiles.size(); ++i) {
            File toCompare = allSourceFiles.get(i);
            for (int j = 0; j < allCompareFiles.size(); ++j) {
                IFileContentResultBean contentResultBean;
                boolean equal;
                File file = allCompareFiles.get(j);
                if (toCompare.equals(file) || !(equal = CompareFileUtils.validateEquality(contentResultBean = CompareFileUtils.compareFiles(toCompare, file, ignoreAbsolutePathEquality, ignoreExtensionEquality, ignoreLengthEquality, ignoreLastModified, ignoreNameEquality, ignoreContentEquality))) || equalFiles.contains(contentResultBean)) continue;
                equalFiles.add(contentResultBean);
            }
        }
        return equalFiles;
    }

    public static IFileCompareResultBean simpleCompareFiles(File sourceFile, File fileToCompare) {
        return CompareFileUtils.compareFiles(sourceFile, fileToCompare, true, false, false, true, false);
    }

    public static boolean validateEquality(IFileCompareResultBean fileCompareResultBean) {
        return fileCompareResultBean.getFileExtensionEquality() && fileCompareResultBean.getLengthEquality() && fileCompareResultBean.getLastModifiedEquality() && fileCompareResultBean.getNameEquality();
    }

    public static boolean validateEquality(IFileContentResultBean fileContentResultBean) {
        return fileContentResultBean.getFileExtensionEquality() && fileContentResultBean.getLengthEquality() && fileContentResultBean.getLastModifiedEquality() && fileContentResultBean.getNameEquality() && fileContentResultBean.getContentEquality();
    }

    private CompareFileUtils() {
    }
}

