/*
 * Decompiled with CFR 0.152.
 */
package de.adesso.wickedcharts.chartjs.chartoptions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.adesso.wickedcharts.chartjs.chartoptions.BorderCapStyle;
import de.adesso.wickedcharts.chartjs.chartoptions.BorderJoinStyle;
import de.adesso.wickedcharts.chartjs.chartoptions.ChartType;
import de.adesso.wickedcharts.chartjs.chartoptions.CubicInterpolationMode;
import de.adesso.wickedcharts.chartjs.chartoptions.PointStyle;
import de.adesso.wickedcharts.chartjs.chartoptions.Position;
import de.adesso.wickedcharts.chartjs.chartoptions.SteppedLineValue;
import de.adesso.wickedcharts.chartjs.chartoptions.colors.Color;
import de.adesso.wickedcharts.chartjs.chartoptions.fillingmodes.BooleanFillingMode;
import de.adesso.wickedcharts.chartjs.chartoptions.fillingmodes.FillingMode;
import de.adesso.wickedcharts.chartjs.chartoptions.valueType.ValueType;
import de.adesso.wickedcharts.chartjs.jackson.serializer.SingleElementListSerializer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public class Dataset
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ChartType type;
    private String label;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> backgroundColor;
    private Color borderColor;
    private Integer borderWidth;
    private List<? extends ValueType> data;
    private FillingMode fill;
    private String stack;
    @JsonProperty(value="yAxisID")
    private String yAxisID;
    @JsonProperty(value="xAxisID")
    private String xAxisID;
    private PointStyle pointStyle;
    private SteppedLineValue steppedLine;
    private Integer lineTension;
    private CubicInterpolationMode cubicInterpolationMode;
    private List<String> borderDash;
    private Number borderDashOffset;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Number> pointRadius;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Number> pointHitRadius;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Number> pointHoverRadius;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Number> pointBorderWidth;
    private Boolean showLine;
    private Boolean spanGaps;
    private Boolean hidden;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> hoverBackgroundColor;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> hoverBorderColor;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> pointBackgroundColor;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> pointBorderColor;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> pointHoverBackgroundColor;
    @JsonSerialize(using=SingleElementListSerializer.class)
    private List<? extends Color> pointHoverBorderColor;
    private Double hoverBorderWidth;
    private BorderCapStyle borderCapStyle;
    private BorderJoinStyle borderJoinStyle;
    private Position borderSkipped;

    public Dataset setHoverBorderColor(Color color) {
        this.hoverBorderColor = Arrays.asList(color);
        return this;
    }

    public Dataset setHoverBorderColor(List<? extends Color> asList) {
        this.hoverBorderColor = asList;
        return this;
    }

    public Dataset setHoverBackgroundColor(Color color) {
        this.hoverBackgroundColor = Arrays.asList(color);
        return this;
    }

    public Dataset setHoverBackgroundColor(List<? extends Color> asList) {
        this.hoverBackgroundColor = asList;
        return this;
    }

    public Dataset setPointHoverBorderColor(Color color) {
        this.pointHoverBorderColor = Arrays.asList(color);
        return this;
    }

    public Dataset setPointHoverBorderColor(List<? extends Color> asList) {
        this.pointHoverBorderColor = asList;
        return this;
    }

    public Dataset setPointHoverBackgroundColor(Color color) {
        this.pointHoverBackgroundColor = Arrays.asList(color);
        return this;
    }

    public Dataset setPointHoverBackgroundColor(List<? extends Color> asList) {
        this.pointHoverBackgroundColor = asList;
        return this;
    }

    public Dataset setPointBorderColor(Color color) {
        this.pointBorderColor = Arrays.asList(color);
        return this;
    }

    public Dataset setPointBorderColor(List<? extends Color> asList) {
        this.pointBorderColor = asList;
        return this;
    }

    public Dataset setPointBackgroundColor(Color color) {
        this.pointBackgroundColor = Arrays.asList(color);
        return this;
    }

    public Dataset setPointBackgroundColor(List<? extends Color> asList) {
        this.pointBackgroundColor = asList;
        return this;
    }

    public Dataset setPointBorderWidth(Number value) {
        this.pointBorderWidth = Arrays.asList(value);
        return this;
    }

    public Dataset setPointBorderWidth(List<? extends Number> list) {
        this.pointBorderWidth = list;
        return this;
    }

    public Dataset setPointHoverRadius(Number value) {
        this.pointHoverRadius = Arrays.asList(value);
        return this;
    }

    public Dataset setPointHoverRadius(List<? extends Number> list) {
        this.pointHoverRadius = list;
        return this;
    }

    public Dataset setPointHitRadius(Number value) {
        this.pointHitRadius = Arrays.asList(value);
        return this;
    }

    public Dataset setPointHitRadius(List<? extends Number> list) {
        this.pointHitRadius = list;
        return this;
    }

    public Dataset setBackgroundColor(Color color) {
        this.backgroundColor = Arrays.asList(color);
        return this;
    }

    public Dataset setBackgroundColor(List<? extends Color> asList) {
        this.backgroundColor = asList;
        return this;
    }

    public Dataset setPointRadius(Number value) {
        this.pointRadius = Arrays.asList(value);
        return this;
    }

    public Dataset setPointRadius(List<? extends Number> list) {
        this.pointRadius = list;
        return this;
    }

    public Dataset setFill(Boolean value) {
        this.fill = value != false ? null : BooleanFillingMode.FALSE;
        return this;
    }

    public Dataset setFill(FillingMode fill) {
        this.fill = fill;
        return this;
    }

    public ChartType getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public List<? extends Color> getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Integer getBorderWidth() {
        return this.borderWidth;
    }

    public List<? extends ValueType> getData() {
        return this.data;
    }

    public FillingMode getFill() {
        return this.fill;
    }

    public String getStack() {
        return this.stack;
    }

    public String getYAxisID() {
        return this.yAxisID;
    }

    public String getXAxisID() {
        return this.xAxisID;
    }

    public PointStyle getPointStyle() {
        return this.pointStyle;
    }

    public SteppedLineValue getSteppedLine() {
        return this.steppedLine;
    }

    public Integer getLineTension() {
        return this.lineTension;
    }

    public CubicInterpolationMode getCubicInterpolationMode() {
        return this.cubicInterpolationMode;
    }

    public List<String> getBorderDash() {
        return this.borderDash;
    }

    public Number getBorderDashOffset() {
        return this.borderDashOffset;
    }

    public List<? extends Number> getPointRadius() {
        return this.pointRadius;
    }

    public List<? extends Number> getPointHitRadius() {
        return this.pointHitRadius;
    }

    public List<? extends Number> getPointHoverRadius() {
        return this.pointHoverRadius;
    }

    public List<? extends Number> getPointBorderWidth() {
        return this.pointBorderWidth;
    }

    public Boolean getShowLine() {
        return this.showLine;
    }

    public Boolean getSpanGaps() {
        return this.spanGaps;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public List<? extends Color> getHoverBackgroundColor() {
        return this.hoverBackgroundColor;
    }

    public List<? extends Color> getHoverBorderColor() {
        return this.hoverBorderColor;
    }

    public List<? extends Color> getPointBackgroundColor() {
        return this.pointBackgroundColor;
    }

    public List<? extends Color> getPointBorderColor() {
        return this.pointBorderColor;
    }

    public List<? extends Color> getPointHoverBackgroundColor() {
        return this.pointHoverBackgroundColor;
    }

    public List<? extends Color> getPointHoverBorderColor() {
        return this.pointHoverBorderColor;
    }

    public Double getHoverBorderWidth() {
        return this.hoverBorderWidth;
    }

    public BorderCapStyle getBorderCapStyle() {
        return this.borderCapStyle;
    }

    public BorderJoinStyle getBorderJoinStyle() {
        return this.borderJoinStyle;
    }

    public Position getBorderSkipped() {
        return this.borderSkipped;
    }

    public Dataset setType(ChartType type) {
        this.type = type;
        return this;
    }

    public Dataset setLabel(String label) {
        this.label = label;
        return this;
    }

    public Dataset setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public Dataset setBorderWidth(Integer borderWidth) {
        this.borderWidth = borderWidth;
        return this;
    }

    public Dataset setData(List<? extends ValueType> data) {
        this.data = data;
        return this;
    }

    public Dataset setStack(String stack) {
        this.stack = stack;
        return this;
    }

    public Dataset setYAxisID(String yAxisID) {
        this.yAxisID = yAxisID;
        return this;
    }

    public Dataset setXAxisID(String xAxisID) {
        this.xAxisID = xAxisID;
        return this;
    }

    public Dataset setPointStyle(PointStyle pointStyle) {
        this.pointStyle = pointStyle;
        return this;
    }

    public Dataset setSteppedLine(SteppedLineValue steppedLine) {
        this.steppedLine = steppedLine;
        return this;
    }

    public Dataset setLineTension(Integer lineTension) {
        this.lineTension = lineTension;
        return this;
    }

    public Dataset setCubicInterpolationMode(CubicInterpolationMode cubicInterpolationMode) {
        this.cubicInterpolationMode = cubicInterpolationMode;
        return this;
    }

    public Dataset setBorderDash(List<String> borderDash) {
        this.borderDash = borderDash;
        return this;
    }

    public Dataset setBorderDashOffset(Number borderDashOffset) {
        this.borderDashOffset = borderDashOffset;
        return this;
    }

    public Dataset setShowLine(Boolean showLine) {
        this.showLine = showLine;
        return this;
    }

    public Dataset setSpanGaps(Boolean spanGaps) {
        this.spanGaps = spanGaps;
        return this;
    }

    public Dataset setHidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    public Dataset setHoverBorderWidth(Double hoverBorderWidth) {
        this.hoverBorderWidth = hoverBorderWidth;
        return this;
    }

    public Dataset setBorderCapStyle(BorderCapStyle borderCapStyle) {
        this.borderCapStyle = borderCapStyle;
        return this;
    }

    public Dataset setBorderJoinStyle(BorderJoinStyle borderJoinStyle) {
        this.borderJoinStyle = borderJoinStyle;
        return this;
    }

    public Dataset setBorderSkipped(Position borderSkipped) {
        this.borderSkipped = borderSkipped;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Dataset)) {
            return false;
        }
        Dataset other = (Dataset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChartType this$type = this.getType();
        ChartType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        List<? extends Color> this$backgroundColor = this.getBackgroundColor();
        List<? extends Color> other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !this$borderColor.equals(other$borderColor)) {
            return false;
        }
        Integer this$borderWidth = this.getBorderWidth();
        Integer other$borderWidth = other.getBorderWidth();
        if (this$borderWidth == null ? other$borderWidth != null : !((Object)this$borderWidth).equals(other$borderWidth)) {
            return false;
        }
        List<? extends ValueType> this$data = this.getData();
        List<? extends ValueType> other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        FillingMode this$fill = this.getFill();
        FillingMode other$fill = other.getFill();
        if (this$fill == null ? other$fill != null : !this$fill.equals(other$fill)) {
            return false;
        }
        String this$stack = this.getStack();
        String other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        String this$yAxisID = this.getYAxisID();
        String other$yAxisID = other.getYAxisID();
        if (this$yAxisID == null ? other$yAxisID != null : !this$yAxisID.equals(other$yAxisID)) {
            return false;
        }
        String this$xAxisID = this.getXAxisID();
        String other$xAxisID = other.getXAxisID();
        if (this$xAxisID == null ? other$xAxisID != null : !this$xAxisID.equals(other$xAxisID)) {
            return false;
        }
        PointStyle this$pointStyle = this.getPointStyle();
        PointStyle other$pointStyle = other.getPointStyle();
        if (this$pointStyle == null ? other$pointStyle != null : !this$pointStyle.equals(other$pointStyle)) {
            return false;
        }
        SteppedLineValue this$steppedLine = this.getSteppedLine();
        SteppedLineValue other$steppedLine = other.getSteppedLine();
        if (this$steppedLine == null ? other$steppedLine != null : !this$steppedLine.equals(other$steppedLine)) {
            return false;
        }
        Integer this$lineTension = this.getLineTension();
        Integer other$lineTension = other.getLineTension();
        if (this$lineTension == null ? other$lineTension != null : !((Object)this$lineTension).equals(other$lineTension)) {
            return false;
        }
        CubicInterpolationMode this$cubicInterpolationMode = this.getCubicInterpolationMode();
        CubicInterpolationMode other$cubicInterpolationMode = other.getCubicInterpolationMode();
        if (this$cubicInterpolationMode == null ? other$cubicInterpolationMode != null : !this$cubicInterpolationMode.equals(other$cubicInterpolationMode)) {
            return false;
        }
        List<String> this$borderDash = this.getBorderDash();
        List<String> other$borderDash = other.getBorderDash();
        if (this$borderDash == null ? other$borderDash != null : !((Object)this$borderDash).equals(other$borderDash)) {
            return false;
        }
        Number this$borderDashOffset = this.getBorderDashOffset();
        Number other$borderDashOffset = other.getBorderDashOffset();
        if (this$borderDashOffset == null ? other$borderDashOffset != null : !this$borderDashOffset.equals(other$borderDashOffset)) {
            return false;
        }
        List<? extends Number> this$pointRadius = this.getPointRadius();
        List<? extends Number> other$pointRadius = other.getPointRadius();
        if (this$pointRadius == null ? other$pointRadius != null : !((Object)this$pointRadius).equals(other$pointRadius)) {
            return false;
        }
        List<? extends Number> this$pointHitRadius = this.getPointHitRadius();
        List<? extends Number> other$pointHitRadius = other.getPointHitRadius();
        if (this$pointHitRadius == null ? other$pointHitRadius != null : !((Object)this$pointHitRadius).equals(other$pointHitRadius)) {
            return false;
        }
        List<? extends Number> this$pointHoverRadius = this.getPointHoverRadius();
        List<? extends Number> other$pointHoverRadius = other.getPointHoverRadius();
        if (this$pointHoverRadius == null ? other$pointHoverRadius != null : !((Object)this$pointHoverRadius).equals(other$pointHoverRadius)) {
            return false;
        }
        List<? extends Number> this$pointBorderWidth = this.getPointBorderWidth();
        List<? extends Number> other$pointBorderWidth = other.getPointBorderWidth();
        if (this$pointBorderWidth == null ? other$pointBorderWidth != null : !((Object)this$pointBorderWidth).equals(other$pointBorderWidth)) {
            return false;
        }
        Boolean this$showLine = this.getShowLine();
        Boolean other$showLine = other.getShowLine();
        if (this$showLine == null ? other$showLine != null : !((Object)this$showLine).equals(other$showLine)) {
            return false;
        }
        Boolean this$spanGaps = this.getSpanGaps();
        Boolean other$spanGaps = other.getSpanGaps();
        if (this$spanGaps == null ? other$spanGaps != null : !((Object)this$spanGaps).equals(other$spanGaps)) {
            return false;
        }
        Boolean this$hidden = this.getHidden();
        Boolean other$hidden = other.getHidden();
        if (this$hidden == null ? other$hidden != null : !((Object)this$hidden).equals(other$hidden)) {
            return false;
        }
        List<? extends Color> this$hoverBackgroundColor = this.getHoverBackgroundColor();
        List<? extends Color> other$hoverBackgroundColor = other.getHoverBackgroundColor();
        if (this$hoverBackgroundColor == null ? other$hoverBackgroundColor != null : !((Object)this$hoverBackgroundColor).equals(other$hoverBackgroundColor)) {
            return false;
        }
        List<? extends Color> this$hoverBorderColor = this.getHoverBorderColor();
        List<? extends Color> other$hoverBorderColor = other.getHoverBorderColor();
        if (this$hoverBorderColor == null ? other$hoverBorderColor != null : !((Object)this$hoverBorderColor).equals(other$hoverBorderColor)) {
            return false;
        }
        List<? extends Color> this$pointBackgroundColor = this.getPointBackgroundColor();
        List<? extends Color> other$pointBackgroundColor = other.getPointBackgroundColor();
        if (this$pointBackgroundColor == null ? other$pointBackgroundColor != null : !((Object)this$pointBackgroundColor).equals(other$pointBackgroundColor)) {
            return false;
        }
        List<? extends Color> this$pointBorderColor = this.getPointBorderColor();
        List<? extends Color> other$pointBorderColor = other.getPointBorderColor();
        if (this$pointBorderColor == null ? other$pointBorderColor != null : !((Object)this$pointBorderColor).equals(other$pointBorderColor)) {
            return false;
        }
        List<? extends Color> this$pointHoverBackgroundColor = this.getPointHoverBackgroundColor();
        List<? extends Color> other$pointHoverBackgroundColor = other.getPointHoverBackgroundColor();
        if (this$pointHoverBackgroundColor == null ? other$pointHoverBackgroundColor != null : !((Object)this$pointHoverBackgroundColor).equals(other$pointHoverBackgroundColor)) {
            return false;
        }
        List<? extends Color> this$pointHoverBorderColor = this.getPointHoverBorderColor();
        List<? extends Color> other$pointHoverBorderColor = other.getPointHoverBorderColor();
        if (this$pointHoverBorderColor == null ? other$pointHoverBorderColor != null : !((Object)this$pointHoverBorderColor).equals(other$pointHoverBorderColor)) {
            return false;
        }
        Double this$hoverBorderWidth = this.getHoverBorderWidth();
        Double other$hoverBorderWidth = other.getHoverBorderWidth();
        if (this$hoverBorderWidth == null ? other$hoverBorderWidth != null : !((Object)this$hoverBorderWidth).equals(other$hoverBorderWidth)) {
            return false;
        }
        BorderCapStyle this$borderCapStyle = this.getBorderCapStyle();
        BorderCapStyle other$borderCapStyle = other.getBorderCapStyle();
        if (this$borderCapStyle == null ? other$borderCapStyle != null : !this$borderCapStyle.equals(other$borderCapStyle)) {
            return false;
        }
        BorderJoinStyle this$borderJoinStyle = this.getBorderJoinStyle();
        BorderJoinStyle other$borderJoinStyle = other.getBorderJoinStyle();
        if (this$borderJoinStyle == null ? other$borderJoinStyle != null : !this$borderJoinStyle.equals(other$borderJoinStyle)) {
            return false;
        }
        Position this$borderSkipped = this.getBorderSkipped();
        Position other$borderSkipped = other.getBorderSkipped();
        return !(this$borderSkipped == null ? other$borderSkipped != null : !this$borderSkipped.equals(other$borderSkipped));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Dataset;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChartType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        List<? extends Color> $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : $borderColor.hashCode());
        Integer $borderWidth = this.getBorderWidth();
        result = result * 59 + ($borderWidth == null ? 43 : ((Object)$borderWidth).hashCode());
        List<? extends ValueType> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        FillingMode $fill = this.getFill();
        result = result * 59 + ($fill == null ? 43 : $fill.hashCode());
        String $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        String $yAxisID = this.getYAxisID();
        result = result * 59 + ($yAxisID == null ? 43 : $yAxisID.hashCode());
        String $xAxisID = this.getXAxisID();
        result = result * 59 + ($xAxisID == null ? 43 : $xAxisID.hashCode());
        PointStyle $pointStyle = this.getPointStyle();
        result = result * 59 + ($pointStyle == null ? 43 : $pointStyle.hashCode());
        SteppedLineValue $steppedLine = this.getSteppedLine();
        result = result * 59 + ($steppedLine == null ? 43 : $steppedLine.hashCode());
        Integer $lineTension = this.getLineTension();
        result = result * 59 + ($lineTension == null ? 43 : ((Object)$lineTension).hashCode());
        CubicInterpolationMode $cubicInterpolationMode = this.getCubicInterpolationMode();
        result = result * 59 + ($cubicInterpolationMode == null ? 43 : $cubicInterpolationMode.hashCode());
        List<String> $borderDash = this.getBorderDash();
        result = result * 59 + ($borderDash == null ? 43 : ((Object)$borderDash).hashCode());
        Number $borderDashOffset = this.getBorderDashOffset();
        result = result * 59 + ($borderDashOffset == null ? 43 : $borderDashOffset.hashCode());
        List<? extends Number> $pointRadius = this.getPointRadius();
        result = result * 59 + ($pointRadius == null ? 43 : ((Object)$pointRadius).hashCode());
        List<? extends Number> $pointHitRadius = this.getPointHitRadius();
        result = result * 59 + ($pointHitRadius == null ? 43 : ((Object)$pointHitRadius).hashCode());
        List<? extends Number> $pointHoverRadius = this.getPointHoverRadius();
        result = result * 59 + ($pointHoverRadius == null ? 43 : ((Object)$pointHoverRadius).hashCode());
        List<? extends Number> $pointBorderWidth = this.getPointBorderWidth();
        result = result * 59 + ($pointBorderWidth == null ? 43 : ((Object)$pointBorderWidth).hashCode());
        Boolean $showLine = this.getShowLine();
        result = result * 59 + ($showLine == null ? 43 : ((Object)$showLine).hashCode());
        Boolean $spanGaps = this.getSpanGaps();
        result = result * 59 + ($spanGaps == null ? 43 : ((Object)$spanGaps).hashCode());
        Boolean $hidden = this.getHidden();
        result = result * 59 + ($hidden == null ? 43 : ((Object)$hidden).hashCode());
        List<? extends Color> $hoverBackgroundColor = this.getHoverBackgroundColor();
        result = result * 59 + ($hoverBackgroundColor == null ? 43 : ((Object)$hoverBackgroundColor).hashCode());
        List<? extends Color> $hoverBorderColor = this.getHoverBorderColor();
        result = result * 59 + ($hoverBorderColor == null ? 43 : ((Object)$hoverBorderColor).hashCode());
        List<? extends Color> $pointBackgroundColor = this.getPointBackgroundColor();
        result = result * 59 + ($pointBackgroundColor == null ? 43 : ((Object)$pointBackgroundColor).hashCode());
        List<? extends Color> $pointBorderColor = this.getPointBorderColor();
        result = result * 59 + ($pointBorderColor == null ? 43 : ((Object)$pointBorderColor).hashCode());
        List<? extends Color> $pointHoverBackgroundColor = this.getPointHoverBackgroundColor();
        result = result * 59 + ($pointHoverBackgroundColor == null ? 43 : ((Object)$pointHoverBackgroundColor).hashCode());
        List<? extends Color> $pointHoverBorderColor = this.getPointHoverBorderColor();
        result = result * 59 + ($pointHoverBorderColor == null ? 43 : ((Object)$pointHoverBorderColor).hashCode());
        Double $hoverBorderWidth = this.getHoverBorderWidth();
        result = result * 59 + ($hoverBorderWidth == null ? 43 : ((Object)$hoverBorderWidth).hashCode());
        BorderCapStyle $borderCapStyle = this.getBorderCapStyle();
        result = result * 59 + ($borderCapStyle == null ? 43 : $borderCapStyle.hashCode());
        BorderJoinStyle $borderJoinStyle = this.getBorderJoinStyle();
        result = result * 59 + ($borderJoinStyle == null ? 43 : $borderJoinStyle.hashCode());
        Position $borderSkipped = this.getBorderSkipped();
        result = result * 59 + ($borderSkipped == null ? 43 : $borderSkipped.hashCode());
        return result;
    }

    public String toString() {
        return "Dataset(type=" + this.getType() + ", label=" + this.getLabel() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", borderWidth=" + this.getBorderWidth() + ", data=" + this.getData() + ", fill=" + this.getFill() + ", stack=" + this.getStack() + ", yAxisID=" + this.getYAxisID() + ", xAxisID=" + this.getXAxisID() + ", pointStyle=" + this.getPointStyle() + ", steppedLine=" + this.getSteppedLine() + ", lineTension=" + this.getLineTension() + ", cubicInterpolationMode=" + this.getCubicInterpolationMode() + ", borderDash=" + this.getBorderDash() + ", borderDashOffset=" + this.getBorderDashOffset() + ", pointRadius=" + this.getPointRadius() + ", pointHitRadius=" + this.getPointHitRadius() + ", pointHoverRadius=" + this.getPointHoverRadius() + ", pointBorderWidth=" + this.getPointBorderWidth() + ", showLine=" + this.getShowLine() + ", spanGaps=" + this.getSpanGaps() + ", hidden=" + this.getHidden() + ", hoverBackgroundColor=" + this.getHoverBackgroundColor() + ", hoverBorderColor=" + this.getHoverBorderColor() + ", pointBackgroundColor=" + this.getPointBackgroundColor() + ", pointBorderColor=" + this.getPointBorderColor() + ", pointHoverBackgroundColor=" + this.getPointHoverBackgroundColor() + ", pointHoverBorderColor=" + this.getPointHoverBorderColor() + ", hoverBorderWidth=" + this.getHoverBorderWidth() + ", borderCapStyle=" + this.getBorderCapStyle() + ", borderJoinStyle=" + this.getBorderJoinStyle() + ", borderSkipped=" + this.getBorderSkipped() + ")";
    }
}

