/*
 * Decompiled with CFR 0.152.
 */
package de.adesso.wickedcharts.chartjs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adesso.wickedcharts.chartjs.chartoptions.ChartType;
import de.adesso.wickedcharts.chartjs.chartoptions.Data;
import de.adesso.wickedcharts.chartjs.chartoptions.Options;
import java.io.Serializable;
import java.util.List;

public class ChartConfiguration
implements Serializable {
    private ChartType type;
    private Data data;
    private Options options;
    @JsonIgnore
    private List<String> optionalJavascript;

    public void addOptionalJavascript(String javascript) {
        this.optionalJavascript.add(javascript);
    }

    public String getOptionalJavascript() {
        if (this.optionalJavascript == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String javascriptElement : this.optionalJavascript) {
            sb.append(javascriptElement);
        }
        return sb.toString();
    }

    public ChartType getType() {
        return this.type;
    }

    public Data getData() {
        return this.data;
    }

    public Options getOptions() {
        return this.options;
    }

    public ChartConfiguration setType(ChartType type) {
        this.type = type;
        return this;
    }

    public ChartConfiguration setData(Data data) {
        this.data = data;
        return this;
    }

    public ChartConfiguration setOptions(Options options) {
        this.options = options;
        return this;
    }

    public ChartConfiguration setOptionalJavascript(List<String> optionalJavascript) {
        this.optionalJavascript = optionalJavascript;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChartConfiguration)) {
            return false;
        }
        ChartConfiguration other = (ChartConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChartType this$type = this.getType();
        ChartType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Data this$data = this.getData();
        Data other$data = other.getData();
        if (this$data == null ? other$data != null : !((Object)this$data).equals(other$data)) {
            return false;
        }
        Options this$options = this.getOptions();
        Options other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$optionalJavascript = this.getOptionalJavascript();
        String other$optionalJavascript = other.getOptionalJavascript();
        return !(this$optionalJavascript == null ? other$optionalJavascript != null : !this$optionalJavascript.equals(other$optionalJavascript));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChartConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChartType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Data $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        Options $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $optionalJavascript = this.getOptionalJavascript();
        result = result * 59 + ($optionalJavascript == null ? 43 : $optionalJavascript.hashCode());
        return result;
    }

    public String toString() {
        return "ChartConfiguration(type=" + this.getType() + ", data=" + this.getData() + ", options=" + this.getOptions() + ", optionalJavascript=" + this.getOptionalJavascript() + ")";
    }
}

