/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd.internal.worker;

import java.io.File;
import java.io.Serializable;
import java.util.Objects;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkParameters;

public interface CpdWorkParameters
extends WorkParameters {
    public Property<String> getEncoding();

    public Property<Boolean> getIgnoreAnnotations();

    public Property<Boolean> getIgnoreFailures();

    public Property<Boolean> getIgnoreIdentifiers();

    public Property<Boolean> getIgnoreLiterals();

    public Property<String> getLanguage();

    public Property<Integer> getMinimumTokenCount();

    public Property<Boolean> getSkipBlocks();

    public Property<String> getSkipBlocksPattern();

    public Property<Boolean> getSkipDuplicateFiles();

    public Property<Boolean> getSkipLexicalErrors();

    public ConfigurableFileCollection getSourceFiles();

    public ListProperty<Report> getReportParameters();

    public static abstract class Report
    implements Serializable {
        private final File destination;

        Report(File destination) {
            this.destination = Objects.requireNonNull(destination, "'destination' must not be null for any report.");
        }

        File getDestination() {
            return this.destination;
        }

        public static class Xml
        extends Report {
            private final String encoding;

            public Xml(File destination, String encoding) {
                super(destination);
                this.encoding = encoding;
            }

            String getEncoding() {
                return this.encoding;
            }
        }

        public static class Vs
        extends Report {
            public Vs(File destination) {
                super(destination);
            }
        }

        public static class Text
        extends Report {
            private final String lineSeparator;
            private final boolean trimLeadingCommonSourceWhitespaces;

            public Text(File destination, String lineSeparator, boolean trimLeadingCommonSourceWhitespaces) {
                super(destination);
                this.lineSeparator = lineSeparator;
                this.trimLeadingCommonSourceWhitespaces = trimLeadingCommonSourceWhitespaces;
            }

            String getLineSeparator() {
                return this.lineSeparator;
            }

            boolean isTrimLeadingCommonSourceWhitespaces() {
                return this.trimLeadingCommonSourceWhitespaces;
            }
        }

        public static class Csv
        extends Report {
            private final Character separator;
            private final boolean includeLineCount;

            public Csv(File destination, Character separator, boolean includeLineCount) {
                super(destination);
                this.separator = separator;
                this.includeLineCount = includeLineCount;
            }

            Character getSeparator() {
                return this.separator;
            }

            boolean isIncludeLineCount() {
                return this.includeLineCount;
            }
        }
    }
}

