/*
 * Decompiled with CFR 0.152.
 */
package de.aaschmid.gradle.plugins.cpd;

import de.aaschmid.gradle.plugins.cpd.CpdCsvFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdReports;
import de.aaschmid.gradle.plugins.cpd.CpdTextFileReport;
import de.aaschmid.gradle.plugins.cpd.CpdXmlFileReport;
import de.aaschmid.gradle.plugins.cpd.internal.CpdReportsImpl;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdAction;
import de.aaschmid.gradle.plugins.cpd.internal.worker.CpdWorkParameters;
import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.util.ClosureBackedAction;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public class Cpd
extends SourceTask
implements VerificationTask,
Reporting<CpdReports> {
    private final ProviderFactory providerFactory;
    private final WorkerExecutor workerExecutor;
    private final CpdReports reports;
    private String encoding;
    private boolean ignoreAnnotations;
    private boolean ignoreFailures;
    private boolean ignoreIdentifiers;
    private boolean ignoreLiterals;
    private String language;
    private Integer minimumTokenCount;
    private FileCollection pmdClasspath;
    private boolean skipDuplicateFiles;
    private boolean skipLexicalErrors;
    private boolean skipBlocks;
    private String skipBlocksPattern;

    @Inject
    public Cpd(ObjectFactory objectFactory, ProviderFactory providerFactory, WorkerExecutor workerExecutor) {
        this.providerFactory = providerFactory;
        this.reports = (CpdReports)objectFactory.newInstance(CpdReportsImpl.class, new Object[]{this});
        this.workerExecutor = workerExecutor;
    }

    @TaskAction
    public void run() {
        this.checkTaskState();
        this.workerExecutor.classLoaderIsolation(action -> action.getClasspath().setFrom((Iterable)this.getPmdClasspath())).submit(CpdAction.class, this.getCpdWorkParameters());
    }

    private void checkTaskState() {
        if (this.getMinimumTokenCount() <= 0) {
            throw new InvalidUserDataException(String.format("Task '%s' requires 'minimumTokenCount' to be greater than zero.", this.getName()));
        }
        if (this.getReports().getEnabledReports().isEmpty()) {
            throw new InvalidUserDataException(String.format("Task '%s' requires at least one required report.", this.getName()));
        }
    }

    private Action<CpdWorkParameters> getCpdWorkParameters() {
        return parameters -> {
            parameters.getEncoding().set((Object)this.getEncodingOrFallback());
            parameters.getIgnoreAnnotations().set((Object)this.getIgnoreAnnotations());
            parameters.getIgnoreFailures().set((Object)this.getIgnoreFailures());
            parameters.getIgnoreIdentifiers().set((Object)this.getIgnoreIdentifiers());
            parameters.getIgnoreLiterals().set((Object)this.getIgnoreLiterals());
            parameters.getLanguage().set((Object)this.getLanguage());
            parameters.getMinimumTokenCount().set((Object)this.getMinimumTokenCount());
            parameters.getSkipBlocks().set((Object)this.getSkipBlocks());
            parameters.getSkipBlocksPattern().set((Object)this.getSkipBlocksPattern());
            parameters.getSkipDuplicateFiles().set((Object)this.getSkipDuplicateFiles());
            parameters.getSkipLexicalErrors().set((Object)this.getSkipLexicalErrors());
            parameters.getSourceFiles().setFrom((Iterable)this.getSource().getFiles());
            parameters.getReportParameters().set(this.createReportParameters(this.getReports()));
        };
    }

    private List<CpdWorkParameters.Report> createReportParameters(CpdReports reports) {
        ArrayList<CpdWorkParameters.Report> result = new ArrayList<CpdWorkParameters.Report>();
        Iterator iterator = reports.iterator();
        while (iterator.hasNext()) {
            SingleFileReport report = (SingleFileReport)iterator.next();
            if (!((Boolean)report.getRequired().get()).booleanValue()) continue;
            if (report instanceof CpdCsvFileReport) {
                Character separator = ((CpdCsvFileReport)report).getSeparator();
                boolean includeLineCount = ((CpdCsvFileReport)report).isIncludeLineCount();
                result.add(new CpdWorkParameters.Report.Csv(((RegularFile)report.getOutputLocation().get()).getAsFile(), separator, includeLineCount));
                continue;
            }
            if (report instanceof CpdTextFileReport) {
                String lineSeparator = ((CpdTextFileReport)report).getLineSeparator();
                boolean trimLeadingCommonSourceWhitespaces = ((CpdTextFileReport)report).getTrimLeadingCommonSourceWhitespaces();
                result.add(new CpdWorkParameters.Report.Text(((RegularFile)report.getOutputLocation().get()).getAsFile(), lineSeparator, trimLeadingCommonSourceWhitespaces));
                continue;
            }
            if (report.getName().equals("vs")) {
                result.add(new CpdWorkParameters.Report.Vs(((RegularFile)report.getOutputLocation().get()).getAsFile()));
                continue;
            }
            if (report instanceof CpdXmlFileReport) {
                String encoding = this.getXmlRendererEncoding((CpdXmlFileReport)report);
                result.add(new CpdWorkParameters.Report.Xml(((RegularFile)report.getOutputLocation().get()).getAsFile(), encoding));
                continue;
            }
            throw new IllegalArgumentException(String.format("Report of type '%s' not available.", report.getClass().getSimpleName()));
        }
        return result;
    }

    @Internal
    String getEncodingOrFallback() {
        String encoding = this.getEncoding();
        if (encoding == null) {
            encoding = (String)this.providerFactory.systemProperty("file.encoding").forUseAtConfigurationTime().get();
        }
        return encoding;
    }

    String getXmlRendererEncoding(CpdXmlFileReport report) {
        String encoding = report.getEncoding();
        if (encoding == null) {
            return this.getEncodingOrFallback();
        }
        return encoding;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    public CpdReports reports(@DelegatesTo(value=CpdReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    @Nested
    public CpdReports getReports() {
        return this.reports;
    }

    public CpdReports reports(Action<? super CpdReports> action) {
        action.execute((Object)this.reports);
        return this.reports;
    }

    @Input
    @Optional
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    public boolean getIgnoreAnnotations() {
        return this.ignoreAnnotations;
    }

    public void setIgnoreAnnotations(boolean ignoreAnnotations) {
        this.ignoreAnnotations = ignoreAnnotations;
    }

    @Input
    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public boolean getIgnoreIdentifiers() {
        return this.ignoreIdentifiers;
    }

    public void setIgnoreIdentifiers(boolean ignoreIdentifiers) {
        this.ignoreIdentifiers = ignoreIdentifiers;
    }

    @Input
    public boolean getIgnoreLiterals() {
        return this.ignoreLiterals;
    }

    public void setIgnoreLiterals(boolean ignoreLiterals) {
        this.ignoreLiterals = ignoreLiterals;
    }

    @Input
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    @Input
    public Integer getMinimumTokenCount() {
        return this.minimumTokenCount;
    }

    public void setMinimumTokenCount(Integer minimumTokenCount) {
        this.minimumTokenCount = minimumTokenCount;
    }

    @Classpath
    public FileCollection getPmdClasspath() {
        return this.pmdClasspath;
    }

    public void setPmdClasspath(FileCollection pmdClasspath) {
        this.pmdClasspath = pmdClasspath;
    }

    @Input
    public boolean getSkipDuplicateFiles() {
        return this.skipDuplicateFiles;
    }

    public void setSkipDuplicateFiles(boolean skipDuplicateFiles) {
        this.skipDuplicateFiles = skipDuplicateFiles;
    }

    @Input
    public boolean getSkipLexicalErrors() {
        return this.skipLexicalErrors;
    }

    public void setSkipLexicalErrors(boolean skipLexicalErrors) {
        this.skipLexicalErrors = skipLexicalErrors;
    }

    @Input
    public boolean getSkipBlocks() {
        return this.skipBlocks;
    }

    public void setSkipBlocks(boolean skipBlocks) {
        this.skipBlocks = skipBlocks;
    }

    @Input
    public String getSkipBlocksPattern() {
        return this.skipBlocksPattern;
    }

    public void setSkipBlocksPattern(String skipBlocksPattern) {
        this.skipBlocksPattern = skipBlocksPattern;
    }
}

