/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.viewmodelbinding;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.databinding.DataBindingUtil;
import android.databinding.ViewDataBinding;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.LayoutInflater;
import cz.kinst.jakub.viewmodelbinding.OnViewModelInitializedCallback;
import cz.kinst.jakub.viewmodelbinding.ViewInterface;
import cz.kinst.jakub.viewmodelbinding.ViewModel;
import cz.kinst.jakub.viewmodelbinding.ViewModelBindingConfig;
import cz.kinst.jakub.viewmodelbinding.ViewModelProvider;
import java.util.UUID;

public class ViewModelBindingHelper<R extends ViewModel, T extends ViewDataBinding> {
    private static final String LOG_TAG = "ViewModelBindingHelper";
    private String mViewModelId;
    private R mViewModel;
    private boolean mModelRemoved;
    private boolean mOnSaveInstanceCalled;
    private T mBinding;
    private boolean mAlreadyCreated;
    private ViewModelBindingConfig<R> mViewModelConfig;

    public void onCreate(ViewInterface<T, R> view, @Nullable Bundle savedInstanceState, OnViewModelInitializedCallback<R> onViewModelInitializedCallback) {
        if (this.mViewModelConfig == null) {
            throw new IllegalStateException("ViewModel has not been set up. You probably need to call setupViewModel() before calling super.onCreate().");
        }
        if (this.mAlreadyCreated) {
            return;
        }
        this.mAlreadyCreated = true;
        if (view instanceof Activity) {
            this.mBinding = DataBindingUtil.setContentView((Activity)((Activity)view), (int)this.mViewModelConfig.getLayoutResource());
        } else if (view instanceof Fragment) {
            this.mBinding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)view.getContext()), (int)this.mViewModelConfig.getLayoutResource(), null, (boolean)false);
        } else {
            throw new IllegalArgumentException("View must be an instance of Activity or Fragment (support-v4).");
        }
        if (this.mViewModelConfig.getViewModelClass() == null) {
            this.mViewModel = null;
            return;
        }
        if (this.mViewModelId == null) {
            this.mViewModelId = savedInstanceState == null ? UUID.randomUUID().toString() : savedInstanceState.getString(this.getViewModelIdFieldName());
        }
        ViewModelProvider.ViewModelWrapper<R> viewModelWrapper = ViewModelProvider.getInstance().getViewModel(view.getContext(), this.mViewModelId, this.mViewModelConfig.getViewModelClass());
        this.mViewModel = viewModelWrapper.getViewModel();
        this.mOnSaveInstanceCalled = false;
        ((ViewModel)((Object)this.mViewModel)).bindView(view);
        this.mBinding.setVariable(this.mViewModelConfig.getViewModelVariableName(), this.mViewModel);
        this.mBinding.setVariable(this.mViewModelConfig.getViewVariableName(), view);
        if (viewModelWrapper.wasCreated()) {
            if (onViewModelInitializedCallback != null) {
                onViewModelInitializedCallback.onViewModelInitialized(this.mViewModel);
            }
            ((ViewModel)((Object)this.mViewModel)).onViewModelCreated();
        }
        ((ViewModel)((Object)this.mViewModel)).onViewAttached(viewModelWrapper.wasCreated());
        ((ViewModel)((Object)this.mViewModel)).internalRunAllUiTasksInQueue();
    }

    public void onResume() {
        if (this.mViewModel != null) {
            ((ViewModel)((Object)this.mViewModel)).onResume();
        }
    }

    public void onPause() {
        if (this.mViewModel != null) {
            ((ViewModel)((Object)this.mViewModel)).onPause();
        }
    }

    public void onDestroyView(@NonNull Fragment fragment) {
        if (this.mViewModel == null) {
            return;
        }
        if (fragment.getActivity() != null && fragment.getActivity().isFinishing()) {
            ((ViewModel)((Object)this.mViewModel)).onViewDetached(true);
            this.removeViewModel();
        } else {
            ((ViewModel)((Object)this.mViewModel)).onViewDetached(false);
            this.mAlreadyCreated = false;
        }
        this.mBinding = null;
    }

    public void onDestroy(@NonNull Fragment fragment) {
        if (this.mViewModel == null) {
            return;
        }
        if (fragment.getActivity().isFinishing()) {
            this.removeViewModel();
        } else if (fragment.isRemoving() && !this.mOnSaveInstanceCalled) {
            Log.d((String)LOG_TAG, (String)"Removing viewmodel - fragment replaced");
            this.removeViewModel();
        }
        this.mAlreadyCreated = false;
    }

    public void onDestroy(@NonNull Activity activity) {
        if (this.mViewModel == null) {
            return;
        }
        if (activity.isFinishing()) {
            ((ViewModel)((Object)this.mViewModel)).onViewDetached(true);
            this.removeViewModel();
        } else {
            ((ViewModel)((Object)this.mViewModel)).onViewDetached(false);
        }
        this.mAlreadyCreated = false;
        this.mBinding = null;
    }

    @Nullable
    public R getViewModel() {
        return this.mViewModel;
    }

    public void onSaveInstanceState(@NonNull Bundle bundle) {
        bundle.putString(this.getViewModelIdFieldName(), this.mViewModelId);
        if (this.mViewModel != null) {
            this.mOnSaveInstanceCalled = true;
        }
    }

    public T getBinding() {
        return this.mBinding;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        ((ViewModel)((Object)this.mViewModel)).onActivityResult(requestCode, resultCode, data);
    }

    public void setup(int layoutResourceId, Class<R> viewModelClass) {
        this.mViewModelConfig = new ViewModelBindingConfig<R>(layoutResourceId, viewModelClass);
    }

    @NonNull
    private String getViewModelIdFieldName() {
        return "__vm_id_" + this.mViewModelConfig.getViewModelClass().getName();
    }

    private void removeViewModel() {
        if (!this.mModelRemoved) {
            ViewModelProvider.getInstance().removeViewModel(this.mViewModelId);
            ((ViewModel)((Object)this.mViewModel)).onViewModelDestroyed();
            this.mModelRemoved = true;
            this.mAlreadyCreated = false;
        }
    }
}

