/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.viewmodelbinding;

import android.databinding.ViewDataBinding;
import android.support.annotation.NonNull;
import cz.kinst.jakub.viewmodelbinding.ViewModel;
import java.util.HashMap;

public class ViewModelProvider {
    private static ViewModelProvider sInstance;
    private final HashMap<String, ViewModel<? extends ViewDataBinding>> mViewModels = new HashMap();

    public static ViewModelProvider getInstance() {
        if (sInstance == null) {
            sInstance = new ViewModelProvider();
        }
        return sInstance;
    }

    private ViewModelProvider() {
    }

    public synchronized void removeViewModel(String viewModelId) {
        this.mViewModels.remove(viewModelId);
    }

    @NonNull
    public synchronized <T extends ViewModel> ViewModelWrapper<T> getViewModel(String viewModelId, @NonNull Class<T> viewModelClass) {
        ViewModel instance = this.mViewModels.get(viewModelId);
        if (instance != null) {
            return new ViewModelWrapper(instance, false, null);
        }
        try {
            instance = (ViewModel)((Object)viewModelClass.newInstance());
            instance.setViewModelId(viewModelId);
            this.mViewModels.put(viewModelId, instance);
            return new ViewModelWrapper(instance, true, null);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class ViewModelWrapper<V extends ViewModel> {
        @NonNull
        private final V mViewModel;
        private final boolean mWasCreated;

        private ViewModelWrapper(@NonNull V viewModel, boolean wasCreated) {
            this.mViewModel = viewModel;
            this.mWasCreated = wasCreated;
        }

        @NonNull
        public V getViewModel() {
            return this.mViewModel;
        }

        public boolean wasCreated() {
            return this.mWasCreated;
        }

        /* synthetic */ ViewModelWrapper(ViewModel x0, boolean x1, 1 x2) {
            this(x0, x1);
        }
    }
}

