/*
 * Decompiled with CFR 0.152.
 */
package cz.kinst.jakub.view;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class StatefulLayout
extends FrameLayout {
    public static final String SAVED_INSTANCE_STATE = "instanceState";
    private static final String SAVED_STATE = "stateful_layout_state";
    private Map<String, View> mStateViews = new HashMap<String, View>();
    private String mState;
    private OnStateChangeListener mOnStateChangeListener;
    private boolean mInitialized;
    private boolean mDirtyFlag = false;

    public StatefulLayout(Context context) {
        super(context);
    }

    public StatefulLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public StatefulLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (!this.mInitialized) {
            this.onSetupContentState();
        }
    }

    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(SAVED_INSTANCE_STATE, super.onSaveInstanceState());
        this.saveInstanceState(bundle);
        return bundle;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.restoreInstanceState(bundle);
            state = bundle.getParcelable(SAVED_INSTANCE_STATE);
        }
        super.onRestoreInstanceState(state);
    }

    public void setStateView(String state, View view) {
        if (this.mStateViews.containsKey(state)) {
            this.removeView(this.mStateViews.get(state));
        }
        this.mStateViews.put(state, view);
        if (view.getParent() == null) {
            this.addView(view);
        }
        view.setVisibility(8);
        this.mDirtyFlag = true;
    }

    @NonNull
    public String getState() {
        return this.mState;
    }

    public void setState(String state) {
        if (this.getStateView(state) == null) {
            throw new IllegalStateException(String.format("Cannot switch to state \"%s\". This state was not defined or the view for this state is null.", state));
        }
        if (this.mState != null && this.mState.equals(state) && !this.mDirtyFlag) {
            return;
        }
        this.mState = state;
        for (String s : this.mStateViews.keySet()) {
            this.mStateViews.get(s).setVisibility(s.equals(state) ? 0 : 8);
        }
        if (this.mOnStateChangeListener != null) {
            this.mOnStateChangeListener.onStateChange(state);
        }
        this.mDirtyFlag = false;
    }

    public void setOnStateChangeListener(OnStateChangeListener listener) {
        this.mOnStateChangeListener = listener;
    }

    public void saveInstanceState(Bundle outState) {
        if (this.mState != null) {
            outState.putString(SAVED_STATE, this.mState);
        }
    }

    public String restoreInstanceState(Bundle savedInstanceState) {
        String state = savedInstanceState.getString(SAVED_STATE);
        this.setState(state);
        return state;
    }

    @Nullable
    public View getStateView(String state) {
        return this.mStateViews.get(state);
    }

    public void clearStates() {
        for (String state : new HashSet<String>(this.mStateViews.keySet())) {
            View view = this.mStateViews.get(state);
            if (state.equals("content")) continue;
            this.removeView(view);
            this.mStateViews.remove(state);
        }
    }

    public void setStateController(StateController stateController) {
        this.clearStates();
        for (String state : stateController.getStates().keySet()) {
            this.setStateView(state, stateController.getStates().get(state));
        }
        stateController.setOnStateChangeListener(new OnStateChangeListener(){

            @Override
            public void onStateChange(String state) {
                StatefulLayout.this.setState(state);
            }
        });
        this.setState(stateController.getState());
    }

    @CallSuper
    protected void onSetupContentState() {
        if (this.getChildCount() != 1 + this.mStateViews.size()) {
            throw new IllegalStateException("Invalid child count. StatefulLayout must have exactly one child.");
        }
        View contentView = this.getChildAt(this.mStateViews.size());
        this.removeView(contentView);
        this.setStateView("content", contentView);
        this.setState("content");
        this.mInitialized = true;
    }

    public static class StateController {
        private Map<String, View> mStateMap = new HashMap<String, View>();
        private String mState = "content";
        private OnStateChangeListener mListener;

        private StateController() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Map<String, View> getStates() {
            return this.mStateMap;
        }

        public String getState() {
            return this.mState;
        }

        public void setState(String newState) {
            this.mState = newState;
            if (this.mListener != null) {
                this.mListener.onStateChange(newState);
            }
        }

        void setOnStateChangeListener(OnStateChangeListener listener) {
            this.mListener = listener;
        }

        public static class Builder {
            StateController mStateController = new StateController();

            public Builder withState(String state, View stateView) {
                this.mStateController.mStateMap.put(state, stateView);
                return this;
            }

            public StateController build() {
                return this.mStateController;
            }
        }
    }

    public static class State {
        public static final String CONTENT = "content";
    }

    public static interface OnStateChangeListener {
        public void onStateChange(String var1);
    }
}

