/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.Assert;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.regex.Pattern;
import net.jcip.annotations.Immutable;

@Immutable
public final class ComparisonOperator {
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("=[a-zA-Z]*=|[><]=?|!=");
    private final String[] symbols;
    private final boolean multiValue;

    public ComparisonOperator(String[] symbols, boolean multiValue) {
        Assert.notEmpty(symbols, "symbols must not be null or empty", new Object[0]);
        String[] stringArray = symbols;
        int n = symbols.length;
        int n2 = 0;
        while (n2 < n) {
            String sym = stringArray[n2];
            Assert.isTrue(this.isValidOperatorSymbol(sym), "symbol must match: %s", SYMBOL_PATTERN);
            ++n2;
        }
        this.multiValue = multiValue;
        this.symbols = (String[])symbols.clone();
    }

    public ComparisonOperator(String symbol, boolean multiValue) {
        this(new String[]{symbol}, multiValue);
    }

    public ComparisonOperator(String symbol, String altSymbol, boolean multiValue) {
        this(new String[]{symbol, altSymbol}, multiValue);
    }

    public ComparisonOperator(String ... symbols) {
        this(symbols, false);
    }

    public String getSymbol() {
        return this.symbols[0];
    }

    public String[] getSymbols() {
        return (String[])this.symbols.clone();
    }

    public boolean isMultiValue() {
        return this.multiValue;
    }

    private boolean isValidOperatorSymbol(String str) {
        return !StringUtils.isBlank(str) && SYMBOL_PATTERN.matcher(str).matches();
    }

    public String toString() {
        return this.getSymbol();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonOperator)) {
            return false;
        }
        ComparisonOperator that = (ComparisonOperator)o;
        return this.getSymbol().equals(that.getSymbol());
    }

    public int hashCode() {
        return this.getSymbol().hashCode();
    }
}

