/*
 * Decompiled with CFR 0.152.
 */
package cz.intik.overflowindicator;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.transitionseverywhere.ChangeBounds;
import com.transitionseverywhere.Fade;
import com.transitionseverywhere.Transition;
import com.transitionseverywhere.TransitionManager;
import com.transitionseverywhere.TransitionSet;
import cz.intik.overflowindicator.OverflowDataObserver;
import cz.intik.overflowindicator.R;
import java.util.Arrays;

public class OverflowPagerIndicator
extends LinearLayout {
    private static final int MAX_INDICATORS = 9;
    private static final int INDICATOR_SIZE_DIP = 12;
    private static final int INDICATOR_MARGIN_DIP = 2;
    private static final float STATE_GONE = 0.0f;
    private static final float STATE_SMALLEST = 0.2f;
    private static final float STATE_SMALL = 0.4f;
    private static final float STATE_NORMAL = 0.6f;
    private static final float STATE_SELECTED = 1.0f;
    private int mIndicatorCount;
    private int mLastSelected;
    private int mIndicatorSize;
    private int mIndicatorMargin;
    private RecyclerView mRecyclerView;
    private OverflowDataObserver mDataObserver;

    public OverflowPagerIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.mIndicatorSize = (int)TypedValue.applyDimension((int)1, (float)12.0f, (DisplayMetrics)dm);
        this.mIndicatorMargin = (int)TypedValue.applyDimension((int)1, (float)2.0f, (DisplayMetrics)dm);
        this.mDataObserver = new OverflowDataObserver(this);
    }

    protected void onDetachedFromWindow() {
        if (this.mRecyclerView != null) {
            try {
                this.mRecyclerView.getAdapter().unregisterAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mDataObserver);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        super.onDetachedFromWindow();
    }

    public void onPageSelected(int position) {
        if (this.mIndicatorCount > 9) {
            this.updateOverflowState(position);
        } else {
            this.updateSimpleState(position);
        }
    }

    public void attachToRecyclerView(RecyclerView recyclerView) {
        this.mRecyclerView = recyclerView;
        this.mRecyclerView.getAdapter().registerAdapterDataObserver((RecyclerView.AdapterDataObserver)this.mDataObserver);
        this.initIndicators();
    }

    void updateIndicatorsCount() {
        if (this.mIndicatorCount != this.mRecyclerView.getAdapter().getItemCount()) {
            this.initIndicators();
        }
    }

    private void initIndicators() {
        this.mLastSelected = -1;
        this.mIndicatorCount = this.mRecyclerView.getAdapter().getItemCount();
        this.createIndicators(this.mIndicatorSize, this.mIndicatorMargin);
        this.onPageSelected(0);
    }

    private void updateSimpleState(int position) {
        if (this.mLastSelected != -1) {
            this.animateViewScale(this.getChildAt(this.mLastSelected), 0.6f);
        }
        this.animateViewScale(this.getChildAt(position), 1.0f);
        this.mLastSelected = position;
    }

    private void updateOverflowState(int position) {
        if (this.mIndicatorCount == 0) {
            return;
        }
        TransitionSet transition = new TransitionSet().setOrdering(0).addTransition((Transition)new ChangeBounds()).addTransition((Transition)new Fade());
        TransitionManager.beginDelayedTransition((ViewGroup)this, (Transition)transition);
        float[] positionStates = new float[this.mIndicatorCount + 1];
        Arrays.fill(positionStates, 0.0f);
        int start = position - 9 + 4;
        int realStart = Math.max(0, start);
        if (realStart + 9 > this.mIndicatorCount) {
            realStart = this.mIndicatorCount - 9;
            positionStates[this.mIndicatorCount - 1] = 0.6f;
            positionStates[this.mIndicatorCount - 2] = 0.6f;
        } else {
            if (realStart + 9 - 2 < this.mIndicatorCount) {
                positionStates[realStart + 9 - 2] = 0.4f;
            }
            if (realStart + 9 - 1 < this.mIndicatorCount) {
                positionStates[realStart + 9 - 1] = 0.2f;
            }
        }
        for (int i = realStart; i < realStart + 9 - 2; ++i) {
            positionStates[i] = 0.6f;
        }
        if (position > 5) {
            positionStates[realStart] = 0.2f;
            positionStates[realStart + 1] = 0.4f;
        } else if (position == 5) {
            positionStates[realStart] = 0.4f;
        }
        positionStates[position] = 1.0f;
        this.updateIndicators(positionStates);
        this.mLastSelected = position;
    }

    private void updateIndicators(float[] positionStates) {
        for (int i = 0; i < this.mIndicatorCount; ++i) {
            View v = this.getChildAt(i);
            float state = positionStates[i];
            if (state == 0.0f) {
                v.setVisibility(8);
                continue;
            }
            v.setVisibility(0);
            this.animateViewScale(v, state);
        }
    }

    private void createIndicators(int indicatorSize, int margin) {
        this.removeAllViews();
        if (this.mIndicatorCount <= 1) {
            return;
        }
        for (int i = 0; i < this.mIndicatorCount; ++i) {
            this.addIndicator(this.mIndicatorCount > 9, indicatorSize, margin);
        }
    }

    private void addIndicator(boolean isOverflowState, int indicatorSize, int margin) {
        View view = new View(this.getContext());
        view.setBackgroundResource(R.drawable.dot);
        if (isOverflowState) {
            this.animateViewScale(view, 0.2f);
        } else {
            this.animateViewScale(view, 0.6f);
        }
        ViewGroup.MarginLayoutParams params = new ViewGroup.MarginLayoutParams(indicatorSize, indicatorSize);
        params.leftMargin = margin;
        params.rightMargin = margin;
        this.addView(view, (ViewGroup.LayoutParams)params);
    }

    private void animateViewScale(@Nullable View view, float scale) {
        if (view == null) {
            return;
        }
        view.animate().scaleX(scale).scaleY(scale);
    }
}

